/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.cli.extension;

import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.cli.extension.CliCommandHandler;
import org.testingisdocumenting.znai.utils.ServiceLoaderUtils;

public class CliCommandHandlers {
    private static Set<CliCommandHandler> handlers = ServiceLoaderUtils.load(CliCommandHandler.class);

    public static void add(CliCommandHandler handler) {
        handlers.add(handler);
    }

    public static void forEach(Consumer<CliCommandHandler> consumer) {
        handlers.forEach(consumer);
    }

    public static boolean hasHandler(String command) {
        return handlers.stream().anyMatch(h2 -> h2.commandName().equals(command));
    }

    public static Stream<String> registeredCommandNames() {
        return handlers.stream().map(CliCommandHandler::commandName);
    }

    public static CliCommandHandler findByCommand(String command) {
        return handlers.stream().filter(h2 -> h2.commandName().equals(command)).findFirst().orElseThrow(() -> new RuntimeException("can't find command handler for command: " + command));
    }
}

