/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.file;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.features.PluginFeature;
import org.testingisdocumenting.znai.extensions.file.SnippetContainerEntriesConverter;
import org.testingisdocumenting.znai.extensions.file.SnippetContentProvider;

public class SnippetHighlightFeature
implements PluginFeature {
    private static final String HIGHLIGHT_KEY = "highlight";
    private final ComponentsRegistry componentsRegistry;
    private final Path highlightFileFullPath;
    private final String highlightPath;
    private final List<Object> highlight;
    private final SnippetContentProvider contentProvider;

    public SnippetHighlightFeature(ComponentsRegistry componentsRegistry, PluginParams pluginParams, SnippetContentProvider contentProvider) {
        this.componentsRegistry = componentsRegistry;
        this.highlightPath = pluginParams.getOpts().get("highlightPath", null);
        this.highlightFileFullPath = this.highlightPath != null ? componentsRegistry.resourceResolver().fullPath(this.highlightPath) : null;
        this.highlight = this.extractHighlight(pluginParams.getOpts().getList(HIGHLIGHT_KEY));
        this.contentProvider = contentProvider;
    }

    @Override
    public void updateProps(Map<String, Object> props) {
        if (!this.highlightProvided()) {
            return;
        }
        SnippetContainerEntriesConverter snippetValidator = new SnippetContainerEntriesConverter(this.contentProvider, HIGHLIGHT_KEY);
        props.put(HIGHLIGHT_KEY, snippetValidator.convertAndValidate(this.highlight));
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles() {
        return this.highlightFileFullPath != null ? Stream.of(AuxiliaryFile.builtTime(this.highlightFileFullPath)) : Stream.empty();
    }

    private List<Object> extractHighlight(List<Object> highlight) {
        if (this.highlightFileFullPath == null) {
            return highlight;
        }
        String textContent = this.componentsRegistry.resourceResolver().textContent(this.highlightPath);
        List<Object> combined = Arrays.asList(textContent.split("\n"));
        combined.addAll(highlight);
        return combined;
    }

    private boolean highlightProvided() {
        return !this.highlight.isEmpty();
    }
}

