/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.resources;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.resources.HttpResource;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.utils.FileUtils;
import org.testingisdocumenting.znai.utils.UrlUtils;

public class HttpBasedResourceResolver
implements ResourcesResolver {
    private final List<String> httpBaseUrls = new ArrayList<String>();
    private final Map<String, Path> urlToCachedFile = new ConcurrentHashMap<String, Path>();
    private final Set<String> notFoundUrls = Collections.synchronizedSet(new HashSet());

    @Override
    public void initialize(Stream<String> filteredLookupPaths) {
        this.httpBaseUrls.clear();
        this.httpBaseUrls.addAll(filteredLookupPaths.collect(Collectors.toList()));
    }

    @Override
    public boolean supportsLookupPath(String lookupPath) {
        return HttpResource.isHttpResource(lookupPath);
    }

    @Override
    public boolean canResolve(String path) {
        if (path == null) {
            return false;
        }
        if (this.notFoundUrls.contains(path)) {
            return false;
        }
        Path cachedFile = this.urlToCachedFile.get(path);
        if (cachedFile != null) {
            return true;
        }
        cachedFile = this.createLocalCache(path);
        if (cachedFile == null) {
            this.notFoundUrls.add(path);
            return false;
        }
        this.urlToCachedFile.put(path, cachedFile);
        return true;
    }

    @Override
    public List<String> listOfTriedLocations(String path) {
        return this.fullUrls(path).collect(Collectors.toList());
    }

    @Override
    public Path fullPath(String path) {
        Path cachedFile = this.urlToCachedFile.get(path);
        if (cachedFile == null) {
            throw new IllegalStateException("file should be cached. check canResolve method");
        }
        return cachedFile;
    }

    private Path createLocalCache(String path) {
        HttpResource httpResource = this.fullUrls(path).map(HttpResource::new).filter(HttpResource::exists).findFirst().orElse(null);
        if (httpResource == null) {
            return null;
        }
        Path cachedFile = this.createTempFile();
        cachedFile.toFile().deleteOnExit();
        FileUtils.writeTextContent(cachedFile, httpResource.getContent());
        return cachedFile;
    }

    private Path createTempFile() {
        try {
            return Files.createTempFile("httpResource", "cache", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path docRootRelativePath(Path path) {
        return null;
    }

    @Override
    public boolean isInsideDoc(Path path) {
        return false;
    }

    @Override
    public boolean isLocalFile(String path) {
        return false;
    }

    private Stream<String> fullUrls(String path) {
        return this.httpBaseUrls.stream().map(baseUrl -> UrlUtils.concat(baseUrl, path));
    }
}

