/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.typescript;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.testingisdocumenting.znai.utils.JsonUtils;
import org.testingisdocumenting.znai.utils.ResourceUtils;

public class TypescriptNodeBasedParser {
    private final OutputStream outputStream;
    private final InputStream inputStream;

    public TypescriptNodeBasedParser() {
        Process node = this.createProcess(ResourceUtils.tempCopyOfResource("typeScriptParserBundle.js"));
        this.inputStream = node.getInputStream();
        this.outputStream = node.getOutputStream();
    }

    public List<Map<String, ?>> parsedFile(Path filePath) {
        this.write(filePath.toAbsolutePath().toString());
        String response = this.readResponse();
        return JsonUtils.deserializeAsList(response);
    }

    private void write(String content) {
        try {
            this.outputStream.write((content + "\n").getBytes());
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String readResponse() {
        Scanner scanner = new Scanner(this.inputStream);
        return scanner.nextLine();
    }

    private Process createProcess(Path scriptPath) {
        try {
            String nodePath = this.getNodePath();
            return new ProcessBuilder(new String[0]).command(nodePath, scriptPath.toAbsolutePath().toString()).redirectErrorStream(true).start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getNodePath() {
        String nodeBin = System.getProperty("node.bin");
        return nodeBin != null ? nodeBin : "node";
    }

    public static void main(String[] args) {
        TypescriptNodeBasedParser parser = new TypescriptNodeBasedParser();
    }
}

