/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http.impl;

import znaishaded.io.netty.buffer.ByteBuf;
import znaishaded.io.netty.buffer.Unpooled;
import znaishaded.io.netty.channel.ChannelFuture;
import znaishaded.io.netty.channel.ChannelFutureListener;
import znaishaded.io.netty.channel.ChannelHandlerContext;
import znaishaded.io.netty.channel.ChannelPromise;
import znaishaded.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import znaishaded.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import znaishaded.io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import znaishaded.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import znaishaded.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import znaishaded.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import znaishaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import znaishaded.io.netty.util.concurrent.Future;
import znaishaded.io.netty.util.concurrent.GenericFutureListener;
import znaishaded.io.vertx.codegen.annotations.Nullable;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.http.GoAway;
import znaishaded.io.vertx.core.http.Http2Settings;
import znaishaded.io.vertx.core.http.HttpConnection;
import znaishaded.io.vertx.core.http.impl.FrameType;
import znaishaded.io.vertx.core.http.impl.Http1xServerConnection;
import znaishaded.io.vertx.core.http.impl.HttpUtils;
import znaishaded.io.vertx.core.http.impl.WebSocketImplBase;
import znaishaded.io.vertx.core.http.impl.ws.WebSocketFrameImpl;
import znaishaded.io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import znaishaded.io.vertx.core.impl.ContextInternal;
import znaishaded.io.vertx.core.impl.VertxInternal;
import znaishaded.io.vertx.core.net.impl.ChannelFutureListenerAdapter;
import znaishaded.io.vertx.core.net.impl.ConnectionBase;
import znaishaded.io.vertx.core.net.impl.VertxHandler;

abstract class Http1xConnectionBase<S extends WebSocketImplBase<S>>
extends ConnectionBase
implements HttpConnection {
    protected S ws;
    private boolean closeFrameSent;

    Http1xConnectionBase(VertxInternal vertx, ChannelHandlerContext chctx, ContextInternal context) {
        super(vertx, chctx, context);
    }

    WebSocketFrame encodeFrame(WebSocketFrameImpl frame) {
        ByteBuf buf = frame.getBinaryData();
        if (buf != Unpooled.EMPTY_BUFFER) {
            buf = VertxHandler.safeBuffer(buf, this.chctx.alloc());
        }
        switch (frame.type()) {
            case BINARY: {
                return new BinaryWebSocketFrame(frame.isFinal(), 0, buf);
            }
            case TEXT: {
                return new TextWebSocketFrame(frame.isFinal(), 0, buf);
            }
            case CLOSE: {
                return new CloseWebSocketFrame(true, 0, buf);
            }
            case CONTINUATION: {
                return new ContinuationWebSocketFrame(frame.isFinal(), 0, buf);
            }
            case PONG: {
                return new PongWebSocketFrame(buf);
            }
            case PING: {
                return new PingWebSocketFrame(buf);
            }
        }
        throw new IllegalStateException("Unsupported websocket msg " + frame);
    }

    private WebSocketFrameInternal decodeFrame(WebSocketFrame msg) {
        FrameType frameType;
        ByteBuf payload = VertxHandler.safeBuffer(msg, this.chctx.alloc());
        boolean isFinal = msg.isFinalFragment();
        if (msg instanceof BinaryWebSocketFrame) {
            frameType = FrameType.BINARY;
        } else if (msg instanceof CloseWebSocketFrame) {
            frameType = FrameType.CLOSE;
        } else if (msg instanceof PingWebSocketFrame) {
            frameType = FrameType.PING;
        } else if (msg instanceof PongWebSocketFrame) {
            frameType = FrameType.PONG;
        } else if (msg instanceof TextWebSocketFrame) {
            frameType = FrameType.TEXT;
        } else if (msg instanceof ContinuationWebSocketFrame) {
            frameType = FrameType.CONTINUATION;
        } else {
            throw new IllegalStateException("Unsupported websocket msg " + msg);
        }
        return new WebSocketFrameImpl(frameType, payload, isFinal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleWsFrame(WebSocketFrame msg) {
        S w;
        WebSocketFrameInternal frame = this.decodeFrame(msg);
        Http1xConnectionBase http1xConnectionBase = this;
        synchronized (http1xConnectionBase) {
            switch (frame.type()) {
                case PING: {
                    this.chctx.writeAndFlush(new PongWebSocketFrame(frame.getBinaryData().copy()));
                    break;
                }
                case CLOSE: {
                    Http1xConnectionBase http1xConnectionBase2 = this;
                    synchronized (http1xConnectionBase2) {
                        if (!this.closeFrameSent) {
                            CloseWebSocketFrame closeFrame = new CloseWebSocketFrame(frame.closeStatusCode(), frame.closeReason());
                            this.chctx.writeAndFlush(closeFrame).addListener(ChannelFutureListener.CLOSE);
                            this.closeFrameSent = true;
                        }
                        break;
                    }
                }
            }
            w = this.ws;
        }
        if (w != null) {
            ((WebSocketImplBase)w).handleFrame(frame);
        }
    }

    @Override
    public void close() {
        this.close(null);
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.closeWithPayload((short)1000, null, handler);
    }

    void closeWithPayload(short code, String reason, Handler<AsyncResult<Void>> handler) {
        if (this.ws == null) {
            super.close(handler);
        } else {
            ByteBuf byteBuf = HttpUtils.generateWSCloseFrameByteBuf(code, reason);
            CloseWebSocketFrame frame = new CloseWebSocketFrame(true, 0, byteBuf);
            ChannelPromise promise = this.chctx.newPromise();
            this.flush(promise);
            promise.addListener(future -> {
                ChannelFuture fut = this.chctx.writeAndFlush(frame);
                boolean server = this instanceof Http1xServerConnection;
                if (server) {
                    fut.addListener(f -> {
                        ChannelFuture closeFut = this.chctx.channel().close();
                        if (handler != null) {
                            closeFut.addListener((GenericFutureListener<? extends Future<? super Void>>)new ChannelFutureListenerAdapter<Object>(this.context, null, handler));
                        }
                    });
                } else if (handler != null) {
                    fut.addListener((GenericFutureListener<? extends Future<? super Void>>)new ChannelFutureListenerAdapter<Object>(this.context, null, handler));
                }
            });
        }
    }

    @Override
    public Http1xConnectionBase closeHandler(Handler<Void> handler) {
        return (Http1xConnectionBase)super.closeHandler(handler);
    }

    @Override
    public Http1xConnectionBase exceptionHandler(Handler<Throwable> handler) {
        return (Http1xConnectionBase)super.exceptionHandler(handler);
    }

    @Override
    public HttpConnection goAway(long errorCode, int lastStreamId, Buffer debugData) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support GOAWAY");
    }

    @Override
    public HttpConnection goAwayHandler(@Nullable Handler<GoAway> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support GOAWAY");
    }

    @Override
    public HttpConnection shutdownHandler(@Nullable Handler<Void> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support GOAWAY");
    }

    @Override
    public HttpConnection shutdown(long timeoutMs) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support GOAWAY");
    }

    @Override
    public Http2Settings settings() {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public HttpConnection updateSettings(Http2Settings settings) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public HttpConnection updateSettings(Http2Settings settings, Handler<AsyncResult<Void>> completionHandler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public Http2Settings remoteSettings() {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public HttpConnection remoteSettingsHandler(Handler<Http2Settings> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public HttpConnection ping(Buffer data, Handler<AsyncResult<Buffer>> pongHandler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support PING");
    }

    @Override
    public HttpConnection pingHandler(@Nullable Handler<Buffer> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support PING");
    }
}

