/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.auth;

import java.util.ArrayList;
import java.util.Map;
import znaishaded.io.vertx.core.json.JsonArray;
import znaishaded.io.vertx.core.json.JsonObject;
import znaishaded.io.vertx.ext.auth.JWTOptions;

public class JWTOptionsConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, JWTOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "algorithm": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAlgorithm((String)member.getValue());
                    break;
                }
                case "audience": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item2 -> {
                        if (item2 instanceof String) {
                            list.add((String)item2);
                        }
                    });
                    obj.setAudience(list);
                    break;
                }
                case "audiences": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item2 -> {
                        if (item2 instanceof String) {
                            obj.addAudience((String)item2);
                        }
                    });
                    break;
                }
                case "expiresInMinutes": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setExpiresInMinutes(((Number)member.getValue()).intValue());
                    break;
                }
                case "expiresInSeconds": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setExpiresInSeconds(((Number)member.getValue()).intValue());
                    break;
                }
                case "header": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setHeader(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "ignoreExpiration": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setIgnoreExpiration((Boolean)member.getValue());
                    break;
                }
                case "issuer": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setIssuer((String)member.getValue());
                    break;
                }
                case "leeway": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setLeeway(((Number)member.getValue()).intValue());
                    break;
                }
                case "noTimestamp": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setNoTimestamp((Boolean)member.getValue());
                    break;
                }
                case "permissions": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item2 -> {
                        if (item2 instanceof String) {
                            list.add((String)item2);
                        }
                    });
                    obj.setPermissions(list);
                    break;
                }
                case "subject": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setSubject((String)member.getValue());
                }
            }
        }
    }

    public static void toJson(JWTOptions obj, JsonObject json) {
        JWTOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(JWTOptions obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getAlgorithm() != null) {
            json.put("algorithm", obj.getAlgorithm());
        }
        if (obj.getAudience() != null) {
            array = new JsonArray();
            obj.getAudience().forEach(item2 -> array.add((String)item2));
            json.put("audience", array);
        }
        json.put("expiresInSeconds", obj.getExpiresInSeconds());
        if (obj.getHeader() != null) {
            json.put("header", obj.getHeader());
        }
        json.put("ignoreExpiration", obj.isIgnoreExpiration());
        if (obj.getIssuer() != null) {
            json.put("issuer", obj.getIssuer());
        }
        json.put("leeway", obj.getLeeway());
        json.put("noTimestamp", obj.isNoTimestamp());
        if (obj.getPermissions() != null) {
            array = new JsonArray();
            obj.getPermissions().forEach(item2 -> array.add((String)item2));
            json.put("permissions", array);
        }
        if (obj.getSubject() != null) {
            json.put("subject", obj.getSubject());
        }
    }
}

