/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.util.concurrent.atomic.AtomicInteger;

public class ProgressBar {
    private static boolean enable;
    private static String last;
    private static final AtomicInteger total;
    private static final AtomicInteger done;

    private static synchronized void print(String message) {
        ProgressBar.clear();
        System.err.print(message);
        last = message;
    }

    public static synchronized void clear() {
        if (last != null) {
            int i;
            for (i = 0; i < last.length(); ++i) {
                System.err.print('\b');
            }
            for (i = 0; i < last.length(); ++i) {
                System.err.print(' ');
            }
            for (i = 0; i < last.length(); ++i) {
                System.err.print('\b');
            }
        }
        last = null;
    }

    public static void incTotal(int nb) {
        total.addAndGet(nb);
        ProgressBar.printBar(done.intValue(), total.intValue());
    }

    private static synchronized void printBar(int done, int total) {
        if (!enable) {
            return;
        }
        if (total == 0) {
            return;
        }
        String message = "[" + ProgressBar.getBar(done, total) + "] " + done + "/" + total;
        ProgressBar.print(message);
    }

    private static String getBar(int done, int total) {
        StringBuilder sb = new StringBuilder();
        int width = 30;
        int value = 30 * done / total;
        for (int i = 0; i < 30; ++i) {
            sb.append(i < value ? (char)'#' : ' ');
        }
        return sb.toString();
    }

    public static void incDone(boolean error) {
        done.incrementAndGet();
        ProgressBar.printBar(done.intValue(), total.intValue());
    }

    public static void setEnable(boolean value) {
        enable = value;
    }

    static {
        last = null;
        total = new AtomicInteger();
        done = new AtomicInteger();
    }
}

