/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.io.File;
import java.io.IOException;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.BlockUml;
import znaishaded.net.sourceforge.plantuml.BlockUmlBuilder;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.ISourceFileReader;
import znaishaded.net.sourceforge.plantuml.SourceFileReaderAbstract;
import znaishaded.net.sourceforge.plantuml.SuggestedFile;
import znaishaded.net.sourceforge.plantuml.preproc.Defines;
import znaishaded.net.sourceforge.plantuml.preproc.FileWithSuffix;
import znaishaded.net.sourceforge.plantuml.security.SFile;

public class SourceFileReaderCopyCat
extends SourceFileReaderAbstract
implements ISourceFileReader {
    public SourceFileReaderCopyCat(Defines defines, File file, File outputDirectory, List<String> config, String charset, FileFormatOption fileFormatOption) throws IOException {
        this.file = file;
        this.fileFormatOption = fileFormatOption;
        if (!file.exists()) {
            throw new IllegalArgumentException();
        }
        String path = file.getParentFile().getPath();
        this.outputDirectory = new File(outputDirectory, path).getAbsoluteFile();
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        this.builder = new BlockUmlBuilder(config, charset, defines, this.getReader(charset), SFile.fromFile(file.getAbsoluteFile().getParentFile()), FileWithSuffix.getFileName(file));
    }

    @Override
    protected SuggestedFile getSuggestedFile(BlockUml blockUml) {
        String newName = blockUml.getFileOrDirname();
        SuggestedFile suggested = null;
        suggested = newName == null ? SuggestedFile.fromOutputFile(new File(this.outputDirectory, this.file.getName()), this.fileFormatOption.getFileFormat(), this.cpt++) : SuggestedFile.fromOutputFile(new File(this.outputDirectory, newName), this.fileFormatOption.getFileFormat(), this.cpt++);
        suggested.getParentFile().mkdirs();
        return suggested;
    }
}

