/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import znaishaded.net.sourceforge.plantuml.cute.Arc;
import znaishaded.net.sourceforge.plantuml.cute.BetweenCorners;
import znaishaded.net.sourceforge.plantuml.cute.MyPoint2D;
import znaishaded.net.sourceforge.plantuml.cute.RotationZoom;
import znaishaded.net.sourceforge.plantuml.cute.TriangleCorner;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorNone;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class CutePath {
    private final List<Arc> arcs = new ArrayList<Arc>();

    public CutePath(String value) {
        MyPoint2D lastAdded = null;
        String tension = null;
        StringTokenizer spl = new StringTokenizer(value, "~:", true);
        while (spl.hasMoreTokens()) {
            String token = spl.nextToken();
            if (token.equals(":")) continue;
            if (token.equals("~")) {
                tension = spl.nextToken();
                String next = spl.nextToken();
                if (next.equals("~")) continue;
                throw new IllegalArgumentException();
            }
            StringTokenizer st = new StringTokenizer(token.replaceAll("[()]", ""), ",^");
            MyPoint2D current = new MyPoint2D(st);
            if (lastAdded != null) {
                this.add(new Arc(lastAdded, current).withTension(tension));
            }
            lastAdded = current;
            tension = null;
        }
        this.add(new Arc(lastAdded, this.arcs.get(0).getA()).withTension(tension));
    }

    public CutePath() {
    }

    public void add(Arc arc) {
        Arc last;
        if (this.arcs.size() > 0 && !(last = this.arcs.get(this.arcs.size() - 1)).getB().equals(arc.getA())) {
            throw new IllegalArgumentException("last=" + last.getB() + " arc=" + arc.getA());
        }
        this.arcs.add(arc);
    }

    private final MyPoint2D getMyPoint2D(int i) {
        return this.getArc(i).getA();
    }

    private Arc getArc(int i) {
        if (i == -1) {
            return this.arcs.get(this.arcs.size() - 1);
        }
        if (i == this.arcs.size()) {
            return this.arcs.get(0);
        }
        if (i == this.arcs.size() + 1) {
            return this.arcs.get(1);
        }
        return this.arcs.get(i);
    }

    private UPath toUPath() {
        TriangleCorner corner0 = new TriangleCorner(this.getMyPoint2D(0), this.getMyPoint2D(1), this.getMyPoint2D(2));
        int swepFlag = corner0.determinant() < 0.0 ? 0 : 1;
        UPath path = new UPath();
        BetweenCorners betweenCornersLast = new BetweenCorners(this.getCorner(this.arcs.size() - 1), this.getCorner(this.arcs.size()), this.arcs.get(this.arcs.size() - 1).getTension());
        betweenCornersLast.initPath(path);
        for (int i = 0; i < this.arcs.size(); ++i) {
            BetweenCorners betweenCorners = new BetweenCorners(this.getCorner(i), this.getCorner(i + 1), this.arcs.get(i).getTension());
            betweenCorners.addToPath(path, swepFlag);
        }
        path.closePath();
        return path;
    }

    private void debugMe(UGraphic ug) {
        for (int i = 0; i < this.arcs.size(); ++i) {
            BetweenCorners betweenCorners = new BetweenCorners(this.getCorner(i), this.getCorner(i + 1), this.arcs.get(i).getTension());
            betweenCorners.debugMe(ug.apply(HColorUtils.BLACK).apply(new HColorNone().bg()));
        }
    }

    private Point2D getPointK(int j) {
        if (this.getMyPoint2D(j).hasCurvation()) {
            return this.getCorner(j).getOnSegmentB(this.getMyPoint2D(j).getCurvation(0.0));
        }
        return this.arcs.get(j - 1).getB();
    }

    private TriangleCorner getCorner(int i) {
        return new TriangleCorner(this.getMyPoint2D(i), this.getMyPoint2D(i - 1), this.getMyPoint2D(i + 1));
    }

    public void drawU(UGraphic ug) {
        UPath path = this.toUPath();
        ug.draw(path);
    }

    public CutePath rotateZoom(RotationZoom rotationZoom) {
        CutePath result = new CutePath();
        for (Arc arc : this.arcs) {
            result.arcs.add(arc.rotateZoom(rotationZoom));
        }
        return result;
    }

    public CutePath withNoTension() {
        CutePath result = new CutePath();
        for (Arc arc : this.arcs) {
            result.arcs.add(arc.withNoTension());
        }
        return result;
    }
}

