/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.geom;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.geom.AbstractFigure;
import znaishaded.net.sourceforge.plantuml.geom.ClosedArea;
import znaishaded.net.sourceforge.plantuml.geom.LineSegmentInt;
import znaishaded.net.sourceforge.plantuml.geom.Point2DInt;

public class Kingdom
extends AbstractFigure {
    private Set<ClosedArea> buildClosedArea(ClosedArea area) {
        if (area.isClosed()) {
            throw new IllegalArgumentException();
        }
        HashSet<ClosedArea> result = new HashSet<ClosedArea>();
        for (LineSegmentInt seg : this.getSegmentsWithExtremity(area.getFreePoint(), area.getSegments())) {
            ClosedArea newArea = area.append(seg);
            if (newArea == null) continue;
            result.add(newArea);
        }
        return Collections.unmodifiableSet(result);
    }

    private void grow(Set<ClosedArea> areas) {
        for (ClosedArea area : new HashSet<ClosedArea>(areas)) {
            if (area.isClosed()) continue;
            areas.addAll(this.buildClosedArea(area));
        }
    }

    public Set<ClosedArea> getAllClosedArea() {
        int lastSize;
        HashSet<ClosedArea> result = new HashSet<ClosedArea>();
        for (LineSegmentInt seg : this.getSegments()) {
            result.add(new ClosedArea().append(seg));
        }
        do {
            lastSize = result.size();
            this.grow(result);
        } while (result.size() != lastSize);
        Iterator it = result.iterator();
        while (it.hasNext()) {
            ClosedArea area = (ClosedArea)it.next();
            if (area.isClosed()) continue;
            it.remove();
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public boolean arePointsConnectable(Point2DInt p1, Point2DInt p2) {
        for (ClosedArea area : this.getAllClosedArea()) {
            if (area.arePointsConnectable(p1, p2)) continue;
            return false;
        }
        return true;
    }
}

