/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.hector2.mpos;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IEntity;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Link;
import znaishaded.net.sourceforge.plantuml.hector2.MinMax;
import znaishaded.net.sourceforge.plantuml.hector2.layering.Layer;
import znaishaded.net.sourceforge.plantuml.hector2.mpos.MutationLayer;

public class Distribution {
    private final List<Layer> layers;

    public Distribution(List<Layer> layers) {
        this.layers = new ArrayList<Layer>(layers);
    }

    public Distribution mute(MutationLayer mutation) {
        Distribution result = new Distribution(this.layers);
        int idx = result.layers.indexOf(mutation.getOriginal());
        if (idx == -1) {
            throw new IllegalArgumentException();
        }
        result.layers.set(idx, mutation.mute());
        return result;
    }

    public double cost(Collection<Link> links) {
        double result = 0.0;
        for (Link link : links) {
            result += this.getLength(link);
        }
        return result;
    }

    private double getLength(Link link) {
        IEntity ent1 = link.getEntity1();
        IEntity ent2 = link.getEntity2();
        int y1 = ent1.getHectorLayer();
        int x1 = this.layers.get(y1).getLongitude(ent1);
        int y2 = ent2.getHectorLayer();
        int x2 = this.layers.get(y2).getLongitude(ent2);
        int dx = x2 - x1;
        int dy = y2 - y1;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public List<MutationLayer> getPossibleMutations() {
        ArrayList<MutationLayer> result = new ArrayList<MutationLayer>();
        for (Layer layer : this.layers) {
            result.addAll(layer.getPossibleMutations());
        }
        return Collections.unmodifiableList(result);
    }

    public final List<Layer> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public MinMax getMinMaxLongitudes() {
        MinMax result = null;
        for (Layer layer : this.layers) {
            if (result == null) {
                result = layer.getMinMaxLongitudes();
                continue;
            }
            result = result.add(layer.getMinMaxLongitudes());
        }
        return result;
    }

    public double getNbLayers() {
        return this.layers.size();
    }
}

