/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.mindmap;

import java.util.List;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines2;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.mindmap.IdeaShape;
import znaishaded.net.sourceforge.plantuml.mindmap.MindMapDiagram;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class CommandMindMapOrgmodeMultiline
extends CommandMultilines2<MindMapDiagram> {
    public CommandMindMapOrgmodeMultiline() {
        super(CommandMindMapOrgmodeMultiline.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandMindMapOrgmodeMultiline.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "([*]+)"), new RegexOptional((IRegex)new RegexLeaf("BACKCOLOR", "\\[(#\\w+)\\]")), new RegexLeaf("SHAPE", "(_)?"), new RegexLeaf(":"), new RegexLeaf("DATA", "(.*)"), RegexLeaf.end());
    }

    @Override
    public String getPatternEnd() {
        return "^(.*);(?:\\s*\\<\\<(.+)\\>\\>)?$";
    }

    @Override
    protected CommandExecutionResult executeNow(MindMapDiagram diagram, BlocLines lines) {
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        List<String> lineLast = StringUtils.getSplit(MyPattern.cmpile(this.getPatternEnd()), lines.getLast().getString());
        lines = lines.removeStartingAndEnding(line0.get("DATA", 0), 1);
        String stereotype = lineLast.get(1);
        if (stereotype != null) {
            lines = lines.overrideLastLine(lineLast.get(0));
        }
        String type = line0.get("TYPE", 0);
        String stringColor = line0.get("BACKCOLOR", 0);
        HColor backColor = null;
        if (stringColor != null) {
            backColor = diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(stringColor);
        }
        if (stereotype == null) {
            return diagram.addIdea(backColor, type.length() - 1, lines.toDisplay(), IdeaShape.fromDesc(line0.get("SHAPE", 0)));
        }
        return diagram.addIdea(stereotype, backColor, type.length() - 1, lines.toDisplay(), IdeaShape.fromDesc(line0.get("SHAPE", 0)));
    }
}

