/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.nwdiag;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.AnnotatedWorker;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.Scale;
import znaishaded.net.sourceforge.plantuml.SkinParam;
import znaishaded.net.sourceforge.plantuml.SpriteContainerEmpty;
import znaishaded.net.sourceforge.plantuml.UmlDiagram;
import znaishaded.net.sourceforge.plantuml.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.InnerStrategy;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.nwdiag.DiagElement;
import znaishaded.net.sourceforge.plantuml.nwdiag.DiagGroup;
import znaishaded.net.sourceforge.plantuml.nwdiag.GridTextBlockDecorated;
import znaishaded.net.sourceforge.plantuml.nwdiag.Network;
import znaishaded.net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import znaishaded.net.sourceforge.plantuml.svek.TextBlockBackcolored;
import znaishaded.net.sourceforge.plantuml.ugraphic.ImageBuilder;
import znaishaded.net.sourceforge.plantuml.ugraphic.MinMax;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEmpty;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class NwDiagram
extends UmlDiagram {
    private boolean initDone;
    private final Map<String, DiagElement> elements = new LinkedHashMap<String, DiagElement>();
    private final List<Network> networks = new ArrayList<Network>();
    private final List<DiagGroup> groups = new ArrayList<DiagGroup>();
    private DiagGroup currentGroup = null;
    private final double margin = 5.0;

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Nwdiag)");
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.NWDIAG;
    }

    public void init() {
        this.initDone = true;
    }

    private Network currentNetwork() {
        if (this.networks.size() == 0) {
            return null;
        }
        return this.networks.get(this.networks.size() - 1);
    }

    public CommandExecutionResult openGroup(String name) {
        if (!this.initDone) {
            return this.error();
        }
        this.currentGroup = new DiagGroup(name, this.currentNetwork());
        this.groups.add(this.currentGroup);
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult openNetwork(String name) {
        if (!this.initDone) {
            return this.error();
        }
        Network network = new Network(name);
        this.networks.add(network);
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult endSomething() {
        if (!this.initDone) {
            return this.error();
        }
        this.currentGroup = null;
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult addElement(String name, String definition) {
        if (!this.initDone) {
            return this.error();
        }
        if (this.currentGroup != null) {
            this.currentGroup.addElement(name);
        }
        if (this.currentNetwork() != null) {
            String shape;
            Map<String, String> props;
            String description;
            DiagElement element = this.elements.get(name);
            if (element == null) {
                element = new DiagElement(name, this.currentNetwork(), this.getSkinParam());
                this.elements.put(name, element);
            }
            if ((description = (props = this.toSet(definition)).get("description")) != null) {
                element.setDescription(description);
            }
            if ((shape = props.get("shape")) != null) {
                element.setShape(shape);
            }
            this.currentNetwork().addElement(element, props);
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult error() {
        return CommandExecutionResult.error("");
    }

    private Map<String, String> toSet(String definition) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (definition == null) {
            return result;
        }
        Pattern p = Pattern.compile("\\s*(\\w+)\\s*=\\s*(\"([^\"]*)\"|[^\\s,]+)");
        Matcher m3 = p.matcher(definition);
        while (m3.find()) {
            String name = m3.group(1);
            String value = m3.group(3) == null ? m3.group(2) : m3.group(3);
            result.put(name, value);
        }
        return result;
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        int margin2;
        int margin1;
        Scale scale = this.getScale();
        double dpiFactor = scale == null ? 1.0 : scale.getScale(100.0, 100.0);
        ISkinParam skinParam = this.getSkinParam();
        if (SkinParam.USE_STYLES()) {
            margin1 = SkinParam.zeroMargin(0);
            margin2 = SkinParam.zeroMargin(0);
        } else {
            margin1 = 0;
            margin2 = 0;
        }
        ImageBuilder imageBuilder = ImageBuilder.buildB(new ColorMapperIdentity(), false, ClockwiseTopRightBottomLeft.margin1margin2(margin1, margin2), null, "", "", dpiFactor, null);
        TextBlockBackcolored result = this.getTextBlock();
        result = new AnnotatedWorker(this, skinParam, fileFormatOption.getDefaultStringBounder()).addAdd(result);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, 0L, os);
    }

    private TextBlockBackcolored getTextBlock() {
        return new TextBlockBackcolored(){

            @Override
            public void drawU(UGraphic ug) {
                NwDiagram.this.drawMe(ug);
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return null;
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return NwDiagram.this.getTotalDimension(stringBounder);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                throw new UnsupportedOperationException();
            }

            @Override
            public HColor getBackcolor() {
                return null;
            }
        };
    }

    private TextBlock toTextBlock(String name, String s2) {
        if (s2 != null) {
            name = name + "\\n" + s2;
        }
        return Display.getWithNewlines(name).create(this.getFontConfiguration(), HorizontalAlignment.RIGHT, new SpriteContainerEmpty());
    }

    private FontConfiguration getFontConfiguration() {
        UFont font = UFont.serif(11);
        return new FontConfiguration(font, HColorUtils.BLACK, HColorUtils.BLACK, false);
    }

    private Dimension2D getTotalDimension(StringBounder stringBounder) {
        return TextBlockUtils.getMinMax(new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                NwDiagram.this.drawMe(ug);
            }
        }, stringBounder, true).getDimension();
    }

    private void drawMe(UGraphic ug) {
        ug = ug.apply(new UTranslate(5.0, 5.0));
        StringBounder stringBounder = ug.getStringBounder();
        GridTextBlockDecorated grid = this.buildGrid();
        double deltaX = 0.0;
        double deltaY = 0.0;
        for (int i = 0; i < this.networks.size(); ++i) {
            Network current = this.networks.get(i);
            String address = current.getOwnAdress();
            TextBlock desc = this.toTextBlock(current.getName(), address);
            Dimension2D dim = desc.calculateDimension(stringBounder);
            if (i == 0) {
                deltaY = (dim.getHeight() - 5.0) / 2.0;
            }
            deltaX = Math.max(deltaX, dim.getWidth());
        }
        double y = 0.0;
        for (int i = 0; i < this.networks.size(); ++i) {
            Network current = this.networks.get(i);
            String address = current.getOwnAdress();
            TextBlock desc = this.toTextBlock(current.getName(), address);
            Dimension2D dim = desc.calculateDimension(stringBounder);
            desc.drawU(ug.apply(new UTranslate(deltaX - dim.getWidth(), y)));
            y += grid.lineHeight(stringBounder, i);
        }
        grid.drawU(ug.apply(ColorParam.activityBorder.getDefaultValue()).apply(ColorParam.activityBackground.getDefaultValue().bg()).apply(new UTranslate(deltaX += 5.0, deltaY)));
        Dimension2D dimGrid = grid.calculateDimension(stringBounder);
        ug.apply(new UTranslate(dimGrid.getWidth() + deltaX + 5.0, dimGrid.getHeight() + deltaY + 5.0)).draw(new UEmpty(1.0, 1.0));
    }

    private Map<Network, String> getLinks(DiagElement element) {
        LinkedHashMap<Network, String> result = new LinkedHashMap<Network, String>();
        for (Network network : this.networks) {
            String s2 = network.getAdress(element);
            if (s2 == null) continue;
            result.put(network, s2);
        }
        return result;
    }

    private GridTextBlockDecorated buildGrid() {
        GridTextBlockDecorated grid = new GridTextBlockDecorated(this.networks.size(), this.elements.size(), this.groups, this.networks);
        for (int i = 0; i < this.networks.size(); ++i) {
            Network current = this.networks.get(i);
            Network next = i + 1 < this.networks.size() ? this.networks.get(i + 1) : null;
            int j = 0;
            for (Map.Entry<String, DiagElement> ent : this.elements.entrySet()) {
                DiagElement element = ent.getValue();
                if (element.getMainNetwork() == current) {
                    Map<Network, String> conns = this.getLinks(element);
                    grid.add(i, j, element.asTextBlock(conns, next));
                }
                ++j;
            }
        }
        return grid;
    }

    public CommandExecutionResult setProperty(String property, String value) {
        if (!this.initDone) {
            return this.error();
        }
        if ("address".equalsIgnoreCase(property) && this.currentNetwork() != null) {
            this.currentNetwork().setOwnAdress(value);
        }
        if ("color".equalsIgnoreCase(property)) {
            HColor color = GridTextBlockDecorated.colors.getColorIfValid(value);
            if (this.currentGroup != null) {
                this.currentGroup.setColor(color);
            } else if (this.currentNetwork() != null) {
                this.currentNetwork().setColor(color);
            }
        }
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult link() {
        if (!this.initDone) {
            return this.error();
        }
        return CommandExecutionResult.ok();
    }
}

