/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.posimo;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.posimo.Block;
import znaishaded.net.sourceforge.plantuml.posimo.Clusterable;

public class Cluster
implements Clusterable {
    private static int CPT = 1;
    private final Cluster parent;
    private final Collection<Block> blocs = new ArrayList<Block>();
    private final Collection<Cluster> children = new ArrayList<Cluster>();
    private final int uid = CPT++;
    private double x;
    private double y;
    private double width;
    private double height;
    private final double titleWidth;
    private final double titleHeight;

    public Cluster(Cluster parent, double titleWidth, double titleHeight) {
        this.parent = parent;
        this.titleWidth = titleWidth;
        this.titleHeight = titleHeight;
        if (parent != null) {
            parent.children.add(this);
        }
    }

    public Collection<Cluster> getSubClusters() {
        return Collections.unmodifiableCollection(this.children);
    }

    public Collection<Block> getRecursiveContents() {
        ArrayList<Block> result = new ArrayList<Block>();
        this.addContentRecurse(result);
        return Collections.unmodifiableCollection(result);
    }

    private void addContentRecurse(Collection<Block> result) {
        result.addAll(this.blocs);
        for (Cluster c : this.children) {
            c.addContentRecurse(result);
        }
    }

    public int getUid() {
        return this.uid;
    }

    public void addBloc(Block b) {
        this.blocs.add(b);
    }

    @Override
    public Cluster getParent() {
        return this.parent;
    }

    public Collection<Block> getContents() {
        return Collections.unmodifiableCollection(this.blocs);
    }

    public Block getBlock(int uid) {
        for (Block b : this.blocs) {
            if (b.getUid() != uid) continue;
            return b;
        }
        for (Cluster sub : this.children) {
            Block result = sub.getBlock(uid);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Point2D getPosition() {
        return new Point2D.Double(this.x, this.y);
    }

    @Override
    public Dimension2D getSize() {
        return new Dimension2DDouble(this.width, this.height);
    }

    public final void setX(double x) {
        this.x = x;
    }

    public final void setY(double y) {
        this.y = y;
    }

    public final void setWidth(double width) {
        this.width = width;
    }

    public final void setHeight(double height) {
        this.height = height;
    }

    public final double getTitleWidth() {
        return this.titleWidth;
    }

    public final double getTitleHeight() {
        return this.titleHeight;
    }

    @Override
    public void moveSvek(double deltaX, double deltaY) {
        throw new UnsupportedOperationException();
    }
}

