/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.Segment;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.Component;
import znaishaded.net.sourceforge.plantuml.skin.SimpleContext2D;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

class SegmentColored {
    private final Segment segment;
    private final SymbolContext colors;
    private final boolean shadowing;
    private final double pos1Initial;

    SegmentColored(double pos1, double pos2, SymbolContext colors, boolean shadowing) {
        this(new Segment(pos1, pos2), colors, shadowing, pos1);
    }

    private SegmentColored(Segment segment, SymbolContext colors, boolean shadowing, double pos1Initial) {
        this.segment = segment;
        this.colors = colors;
        this.shadowing = shadowing;
        this.pos1Initial = pos1Initial;
    }

    public HColor getSpecificBackColor() {
        if (this.colors == null) {
            return null;
        }
        return this.colors.getBackColor();
    }

    public HColor getSpecificLineColor() {
        if (this.colors == null) {
            return null;
        }
        return this.colors.getForeColor();
    }

    public boolean equals(Object obj) {
        SegmentColored this2 = (SegmentColored)obj;
        return this.segment.equals(this2.segment);
    }

    public int hashCode() {
        return this.segment.hashCode();
    }

    public String toString() {
        return this.segment.toString();
    }

    public void drawU(UGraphic ug, Component compAliveBox, int level) {
        StringBounder stringBounder = ug.getStringBounder();
        ug = ug.apply(new UTranslate((double)(level - 1) * compAliveBox.getPreferredWidth(stringBounder) / 2.0, this.segment.getPos1()));
        Dimension2DDouble dim = new Dimension2DDouble(compAliveBox.getPreferredWidth(stringBounder), this.segment.getPos2() - this.segment.getPos1());
        compAliveBox.drawU(ug, new Area(dim), new SimpleContext2D(false));
    }

    public Collection<SegmentColored> cutSegmentIfNeed(Collection<Segment> allDelays) {
        return new Coll2(this.segment.cutSegmentIfNeed(allDelays), this.segment.getPos1());
    }

    public double getPos1Initial() {
        return this.pos1Initial;
    }

    public SegmentColored merge(SegmentColored this2) {
        Segment merge = this.segment.merge(this2.segment);
        return new SegmentColored(merge, this.colors, this.shadowing, merge.getPos1());
    }

    public final Segment getSegment() {
        return this.segment;
    }

    class Coll2
    extends AbstractCollection<SegmentColored> {
        private final Collection<Segment> col;
        private final double pos1Initial;

        public Coll2(Collection<Segment> col, double pos1Initial) {
            this.col = col;
            this.pos1Initial = pos1Initial;
        }

        @Override
        public Iterator<SegmentColored> iterator() {
            return new Iterator2(this.col.iterator(), this.pos1Initial);
        }

        @Override
        public int size() {
            return this.col.size();
        }
    }

    class Iterator2
    implements Iterator<SegmentColored> {
        private final Iterator<Segment> it;
        private final double pos1Initial;

        public Iterator2(Iterator<Segment> it, double pos1Initial) {
            this.it = it;
            this.pos1Initial = pos1Initial;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public SegmentColored next() {
            return new SegmentColored(this.it.next(), SegmentColored.this.colors, SegmentColored.this.shadowing, this.pos1Initial);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

