/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.LineConfigurable;
import znaishaded.net.sourceforge.plantuml.SkinParamUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.cucadiagram.BodyEnhanced;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Member;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.USymbol;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageState2
extends AbstractEntityImage {
    private final Url url;
    private final LineConfigurable lineConfig;
    private final TextBlock asSmall;

    public EntityImageState2(ILeaf entity, ISkinParam skinParam) {
        super(entity, skinParam);
        this.lineConfig = entity;
        Stereotype stereotype = entity.getStereotype();
        Display list = Display.empty();
        for (Member att : entity.getBodier().getFieldsToDisplay()) {
            list = list.addAll(Display.getWithNewlines(att.getDisplay(true)));
        }
        USymbol symbol = USymbol.FRAME;
        HColor backcolor = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), symbol.getColorParamBack());
        }
        HColor forecolor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), symbol.getColorParamBorder());
        SymbolContext ctx = new SymbolContext(backcolor, forecolor).withStroke(new UStroke(1.5)).withShadow(this.getSkinParam().shadowing(this.getEntity().getStereotype()) ? 3.0 : 0.0);
        this.url = entity.getUrl99();
        TextBlock stereo = TextBlockUtils.empty(0.0, 0.0);
        BodyEnhanced desc = new BodyEnhanced(entity.getDisplay(), symbol.getFontParam(), skinParam, HorizontalAlignment.CENTER, stereotype, symbol.manageHorizontalLine(), false, entity, SName.stateDiagram);
        this.asSmall = symbol.asSmall(null, desc, stereo, ctx, skinParam.getStereotypeAlignment());
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.asSmall.calculateDimension(stringBounder);
    }

    @Override
    public final void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        this.asSmall.drawU(ug);
        if (this.url != null) {
            ug.closeUrl();
        }
    }
}

