/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.color;

import java.awt.Color;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HUSLColorConverter;

public class ColorUtils {
    static int getGrayScale(Color color) {
        int grayScale = (int)((double)color.getRed() * 0.3 + (double)color.getGreen() * 0.59 + (double)color.getBlue() * 0.11);
        return grayScale;
    }

    public static Color getGrayScaleColor(Color color) {
        int grayScale = ColorUtils.getGrayScale(color);
        return new Color(grayScale, grayScale, grayScale);
    }

    public static Color getGrayScaleColorReverse(Color color) {
        int grayScale = 255 - ColorUtils.getGrayScale(color);
        return new Color(grayScale, grayScale, grayScale);
    }

    public static synchronized Color getReversed(Color color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        double[] hsluv = HUSLColorConverter.rgbToHsluv(new double[]{(double)red / 256.0, (double)green / 256.0, (double)blue / 256.0});
        double h2 = hsluv[0];
        double s2 = hsluv[1];
        double l = hsluv[2];
        if (s2 > 40.0 && s2 < 60.0) {
            if (l > 50.0) {
                l -= 50.0;
            } else if (l < 50.0) {
                l += 50.0;
            }
        } else {
            l = 100.0 - l;
        }
        double[] rgb = HUSLColorConverter.hsluvToRgb(new double[]{h2, s2, l});
        int red2 = ColorUtils.to255(rgb[0]);
        int green2 = ColorUtils.to255(rgb[1]);
        int blue2 = ColorUtils.to255(rgb[2]);
        return new Color(red2, green2, blue2);
    }

    private static int to255(double value) {
        int result = (int)(255.0 * value);
        if (result < 0) {
            return 0;
        }
        if (result > 255) {
            return 255;
        }
        return result;
    }
}

