/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.wire;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import znaishaded.net.sourceforge.plantuml.AnnotatedWorker;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.Scale;
import znaishaded.net.sourceforge.plantuml.SkinParam;
import znaishaded.net.sourceforge.plantuml.UmlDiagram;
import znaishaded.net.sourceforge.plantuml.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.Position;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.graphic.InnerStrategy;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import znaishaded.net.sourceforge.plantuml.svek.TextBlockBackcolored;
import znaishaded.net.sourceforge.plantuml.ugraphic.ImageBuilder;
import znaishaded.net.sourceforge.plantuml.ugraphic.MinMax;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.wire.Block;

public class WireDiagram
extends UmlDiagram {
    private final Block root;
    private Block current;
    private Block last;

    public WireDiagram() {
        this.current = this.root = new Block(this.getSkinParam());
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("Wire Diagram");
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.WIRE;
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        int margin2;
        int margin1;
        Scale scale = this.getScale();
        double dpiFactor = scale == null ? this.getScaleCoef(fileFormatOption) : scale.getScale(100.0, 100.0);
        ISkinParam skinParam = this.getSkinParam();
        if (SkinParam.USE_STYLES()) {
            margin1 = SkinParam.zeroMargin(10);
            margin2 = SkinParam.zeroMargin(10);
        } else {
            margin1 = 10;
            margin2 = 10;
        }
        ImageBuilder imageBuilder = ImageBuilder.buildB(skinParam.getColorMapper(), skinParam.handwritten(), ClockwiseTopRightBottomLeft.margin1margin2(margin1, margin2), null, fileFormatOption.isWithMetadata() ? this.getMetadata() : null, "", dpiFactor, skinParam.getBackgroundColor(false));
        TextBlockBackcolored result = this.getTextBlock();
        result = new AnnotatedWorker(this, skinParam, fileFormatOption.getDefaultStringBounder()).addAdd(result);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, this.seed(), os);
    }

    private TextBlockBackcolored getTextBlock() {
        return new TextBlockBackcolored(){

            @Override
            public void drawU(UGraphic ug) {
                WireDiagram.this.drawMe(ug);
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return null;
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return WireDiagram.this.getDrawingElement().calculateDimension(stringBounder);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                throw new UnsupportedOperationException();
            }

            @Override
            public HColor getBackcolor() {
                return null;
            }
        };
    }

    private void drawMe(UGraphic ug) {
        this.getDrawingElement().drawU(ug);
    }

    private TextBlock getDrawingElement() {
        return this.current;
    }

    public CommandExecutionResult addComponent(String name) {
        return this.addComponent(name, 100, 100);
    }

    public CommandExecutionResult addComponent(String name, int width, int height) {
        this.last = this.current.addNewBlock(name, width, height);
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult vspace(int vspace) {
        this.current.vspace(vspace);
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult newColumn() {
        this.current.newColumn();
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult addStartContainer(String name) {
        this.current = this.current.createContainer(name);
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult componentEnd() {
        this.current = this.current.componentEnd();
        return CommandExecutionResult.ok();
    }

    public void addPin(Position position, String pin) {
        this.last.addPin(position, pin);
    }
}

