/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.enterprise.docpreparation;

import org.testingisdocumenting.znai.enterprise.EnterpriseComponentsRegistry;
import org.testingisdocumenting.znai.enterprise.storage.DocumentationFileBasedTimestamp;
import org.testingisdocumenting.znai.server.docpreparation.DocumentationPreparationHandler;
import org.testingisdocumenting.znai.server.docpreparation.DocumentationPreparationHandlers;
import org.testingisdocumenting.znai.server.docpreparation.DocumentationPreparationProgress;
import znaishaded.org.apache.commons.lang3.StringUtils;

public class StorageBasedDocumentationPreparationHandler
implements DocumentationPreparationHandler {
    private static final String SERVER_URL = System.getProperty("znai.server.url");

    @Override
    public boolean handles(String docId) {
        return EnterpriseComponentsRegistry.enterpriseConfig().getDocStorageRoot() != null && EnterpriseComponentsRegistry.documentationStorage().contains(docId);
    }

    @Override
    public boolean isReady(String docId) {
        long currentTimestamp;
        long storageUpdateTime = EnterpriseComponentsRegistry.documentationStorage().lastUpdateTime(docId, "");
        return storageUpdateTime <= (currentTimestamp = DocumentationFileBasedTimestamp.read(EnterpriseComponentsRegistry.serverConfig().getDeployRoot().resolve(docId)));
    }

    @Override
    public void prepare(String docId, DocumentationPreparationProgress preparationProgress) {
        EnterpriseComponentsRegistry.documentationStorage().prepare(docId, "", preparationProgress);
    }

    static {
        if (StringUtils.isNotBlank(SERVER_URL)) {
            DocumentationPreparationHandlers.add(new StorageBasedDocumentationPreparationHandler());
        }
    }
}

