/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.extensions.Plugin;
import org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.extensions.inlinedcode.InlinedCodePlugin;
import org.testingisdocumenting.znai.utils.ServiceLoaderUtils;

public class Plugins {
    private static final Map<String, Plugin> includePluginsById = Plugins.discoverIncludePlugins();
    private static final Map<String, Plugin> fencePluginsById = Plugins.discoverFencePlugins();
    private static final Map<String, Plugin> inlineCodePluginsById = Plugins.discoverInlinedCodePlugins();

    public static IncludePlugin includePluginById(String id) {
        return (IncludePlugin)Plugins.pluginById(includePluginsById, id);
    }

    public static boolean hasFencePlugin(String id) {
        return fencePluginsById.containsKey(id);
    }

    public static FencePlugin fencePluginById(String id) {
        return (FencePlugin)Plugins.pluginById(fencePluginsById, id);
    }

    public static boolean hasInlinedCodePlugin(String id) {
        return inlineCodePluginsById.containsKey(id);
    }

    public static InlinedCodePlugin inlinedCodePluginById(String id) {
        return (InlinedCodePlugin)Plugins.pluginById(inlineCodePluginsById, id);
    }

    private static Plugin pluginById(Map<String, Plugin> plugins, String id) {
        Plugin plugin = plugins.get(id);
        if (plugin == null) {
            throw new RuntimeException("can't find plugin with id '" + id + "'. full list\n: " + Plugins.renderListOfPlugins(plugins.values()));
        }
        return plugin.create();
    }

    private static Map<String, Plugin> discoverIncludePlugins() {
        return Plugins.discoverPlugins(IncludePlugin.class);
    }

    private static Map<String, Plugin> discoverFencePlugins() {
        return Plugins.discoverPlugins(FencePlugin.class);
    }

    private static Map<String, Plugin> discoverInlinedCodePlugins() {
        return Plugins.discoverPlugins(InlinedCodePlugin.class);
    }

    private static <E extends Plugin> Map<String, Plugin> discoverPlugins(Class<E> pluginType) {
        Set<E> list = ServiceLoaderUtils.load(pluginType);
        Map<String, Plugin> byId = list.stream().collect(Collectors.toMap(Plugin::id, p -> p));
        if (byId.size() < list.size()) {
            throw new IllegalStateException("multiple plugins with the same id are detected. full list: \n" + Plugins.renderListOfPlugins(list));
        }
        return byId;
    }

    private static <E extends Plugin> String renderListOfPlugins(Collection<E> list) {
        return list.stream().map(p -> p.id() + ":" + p.getClass()).collect(Collectors.joining("\n"));
    }
}

