/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PluginsRegexp {
    public static final Pattern INCLUDE_PLUGIN_PATTERN = Pattern.compile("^\\s*:include-(\\S+)+:\\s*(.*)$");
    public static final Pattern INLINED_CODE_PATTERN = Pattern.compile("^:([a-zA-Z-_]+):\\s*(.*)");

    private PluginsRegexp() {
    }

    public static IdAndParams parseIncludePlugin(CharSequence line) {
        return PluginsRegexp.parse(INCLUDE_PLUGIN_PATTERN, line);
    }

    public static IdAndParams parseInlinedCodePlugin(CharSequence line) {
        return PluginsRegexp.parse(INLINED_CODE_PATTERN, line);
    }

    public static IdAndParams parse(Pattern pattern, CharSequence line) {
        Matcher matcher = pattern.matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        return new IdAndParams(matcher.group(1).trim(), matcher.group(2).trim());
    }

    public static class IdAndParams {
        private final String id;
        private final String params;

        public IdAndParams(String id, String params) {
            this.id = id;
            this.params = params;
        }

        public String getId() {
            return this.id;
        }

        public String getParams() {
            return this.params;
        }
    }
}

