/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.xml;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.extensions.validation.EntryPresenceValidation;
import org.testingisdocumenting.znai.extensions.xml.XmlPaths;
import org.testingisdocumenting.znai.extensions.xml.XmlToMapRepresentationConverter;
import org.testingisdocumenting.znai.parser.ParserHandler;

public class XmlIncludePlugin
implements IncludePlugin {
    private String fileName;

    @Override
    public String id() {
        return "xml";
    }

    @Override
    public IncludePlugin create() {
        return new XmlIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.fileName = pluginParams.getFreeParam();
        String xml = componentsRegistry.resourceResolver().textContent(this.fileName);
        Map<String, Object> props = pluginParams.getOpts().toMap();
        Map<String, ?> xmlAsJson = XmlToMapRepresentationConverter.convert(xml);
        List<String> paths = pluginParams.getOpts().getList("paths");
        XmlIncludePlugin.validatePaths(xmlAsJson, paths);
        props.put("xmlAsJson", xmlAsJson);
        props.put("paths", paths);
        return PluginResult.docElement("Xml", props);
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime(componentsRegistry.resourceResolver().fullPath(this.fileName)));
    }

    private static void validatePaths(Map<String, ?> xmlAsJson, List<String> paths) {
        Set<String> existingPaths = XmlIncludePlugin.buildPaths(xmlAsJson);
        EntryPresenceValidation.validateItemsPresence("path", "XML", existingPaths, paths);
    }

    private static Set<String> buildPaths(Map<String, ?> xmlAsJson) {
        return new XmlPaths(xmlAsJson).getPaths();
    }
}

