/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.python.pydoc;

import java.util.List;
import java.util.Set;
import org.testingisdocumenting.znai.python.PythonParam;
import org.testingisdocumenting.znai.python.pydoc.PythonDocParamsParser;
import org.testingisdocumenting.znai.utils.ServiceLoaderUtils;

public class ParsedPythonDoc {
    private static final Set<PythonDocParamsParser> paramsParsers = ServiceLoaderUtils.load(PythonDocParamsParser.class);
    private final String pyDoc;
    private final List<PythonParam> params;

    public ParsedPythonDoc(String pyDoc) {
        this.pyDoc = pyDoc;
        this.params = this.createParamsParser().parse(pyDoc);
    }

    public String getPyDoc() {
        return this.pyDoc;
    }

    public List<PythonParam> getParams() {
        return this.params;
    }

    private PythonDocParamsParser createParamsParser() {
        return paramsParsers.stream().filter(parser -> parser.handles(this.pyDoc)).findFirst().map(PythonDocParamsParser::create).orElseThrow(() -> new RuntimeException("can't find pythod doc params parser to parse:\n" + this.pyDoc));
    }
}

