/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.python.pydoc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testingisdocumenting.znai.python.PythonParam;
import org.testingisdocumenting.znai.python.pydoc.PythonDocParamsParser;
import org.testingisdocumenting.znai.utils.StringUtils;

public class PythonDocPandasLikeParamsParser
implements PythonDocParamsParser {
    private final String HEADER = "Parameters";
    private final Pattern PARAMETERS_START = Pattern.compile("Parameters\\s+_+");
    private final List<PythonParam> params = new ArrayList<PythonParam>();
    private String currentName = "";
    private String currentType;
    private List<String> currentDocLines;

    @Override
    public boolean handles(String pyDoc) {
        return this.PARAMETERS_START.matcher(pyDoc).find();
    }

    @Override
    public PythonDocPandasLikeParamsParser create() {
        return new PythonDocPandasLikeParamsParser();
    }

    @Override
    public List<PythonParam> parse(String pyDoc) {
        String line;
        LineHandleResult result;
        String[] lines;
        Matcher matcher = this.PARAMETERS_START.matcher(pyDoc);
        if (!matcher.find()) {
            throw new RuntimeException("Can't find block with Parameters with underscore");
        }
        int start = matcher.start();
        String fromParams = pyDoc.substring(start);
        String[] stringArray = lines = fromParams.split("\n");
        int n = stringArray.length;
        for (int i = 0; i < n && (result = this.handleLine(line = stringArray[i])) != LineHandleResult.BREAK; ++i) {
        }
        this.flushParamIfRequired();
        return Collections.unmodifiableList(this.params);
    }

    private LineHandleResult handleLine(String line) {
        String trimmed = line.trim();
        if (trimmed.equals("Parameters")) {
            return LineHandleResult.CONTINUE;
        }
        if (line.startsWith("__")) {
            return LineHandleResult.CONTINUE;
        }
        if (trimmed.isEmpty() && this.currentName.isEmpty()) {
            return LineHandleResult.CONTINUE;
        }
        if (line.startsWith(" ") || trimmed.isEmpty()) {
            this.currentDocLines.add(line);
            return LineHandleResult.CONTINUE;
        }
        String[] parts = trimmed.split(":");
        if (parts.length == 2) {
            this.startNewParam(parts[0], parts[1]);
            return LineHandleResult.CONTINUE;
        }
        return LineHandleResult.BREAK;
    }

    private void startNewParam(String name, String type) {
        this.flushParamIfRequired();
        this.currentName = name;
        this.currentType = type;
        this.currentDocLines = new ArrayList<String>();
    }

    private void flushParamIfRequired() {
        if (this.currentName.isEmpty()) {
            return;
        }
        this.params.add(new PythonParam(this.currentName.trim(), this.currentType.trim(), StringUtils.stripIndentation(String.join((CharSequence)"\n", this.currentDocLines))));
        this.currentName = "";
    }

    private static enum LineHandleResult {
        CONTINUE,
        BREAK;

    }
}

