/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.resources;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.resources.HttpResource;
import org.testingisdocumenting.znai.resources.ResourcesResolver;

public class MultipleLocalLocationsResourceResolver
implements ResourcesResolver {
    private final Path docRootPath;
    private final List<Path> lookupPaths;
    private final ThreadLocal<Path> currentFilePath;

    public MultipleLocalLocationsResourceResolver(Path docRootPath) {
        this.docRootPath = docRootPath;
        this.lookupPaths = new ArrayList<Path>();
        this.currentFilePath = new ThreadLocal();
    }

    @Override
    public void initialize(Stream<String> filteredLookupPaths) {
        this.lookupPaths.clear();
        this.lookupPaths.addAll(filteredLookupPaths.map(this.docRootPath::resolve).collect(Collectors.toList()));
    }

    @Override
    public boolean supportsLookupPath(String lookupPath) {
        return !HttpResource.isHttpResource(lookupPath);
    }

    @Override
    public boolean canResolve(String path) {
        return this.isLocalFile(path);
    }

    @Override
    public List<String> listOfTriedLocations(String path) {
        return this.allLocationsStream(path).map(Path::toString).collect(Collectors.toList());
    }

    @Override
    public Path fullPath(String path) {
        return this.allLocationsStream(path).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().orElseThrow(() -> new IllegalStateException("either file disappeared or canResolve implementation needs to be checked."));
    }

    @Override
    public Path docRootRelativePath(Path path) {
        return this.docRootPath.relativize(path);
    }

    @Override
    public boolean isInsideDoc(Path path) {
        return path.toAbsolutePath().startsWith(this.docRootPath);
    }

    @Override
    public boolean isLocalFile(String path) {
        return this.allLocationsStream(path).anyMatch(x$0 -> Files.exists(x$0, new LinkOption[0]));
    }

    private Stream<Path> allLocationsStream(String path) {
        Path original = Paths.get(path, new String[0]);
        Stream relativeToCurrent = this.currentFilePath.get() == null ? Stream.empty() : Stream.of(this.currentFilePath.get().getParent().resolve(path));
        Stream<Object> absoluteLocation = original.isAbsolute() ? Stream.of(original) : Stream.empty();
        Stream<Path> lookedUpInLocations = this.lookupPaths.stream().map(p -> p.resolve(path).normalize());
        return Stream.concat(relativeToCurrent, Stream.concat(absoluteLocation, lookedUpInLocations));
    }

    public void setCurrentFilePath(Path currentFilePath) {
        this.currentFilePath.set(currentFilePath);
    }
}

