/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.utils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class StringUtils {
    private StringUtils() {
    }

    public static int maxLineLength(String text) {
        return Arrays.stream(text.replace("\r", "").split("\n")).map(String::length).max(Integer::compareTo).orElse(0);
    }

    public static String stripIndentation(String text) {
        List<String> lines = StringUtils.trimEmptyLines(Arrays.asList(text.replace("\r", "").split("\n")));
        Integer indentation = lines.stream().filter(StringUtils::notEmptyLine).map(StringUtils::lineIndentation).min(Integer::compareTo).orElse(0);
        return lines.stream().map(l -> StringUtils.removeIndentation(l, indentation)).collect(Collectors.joining("\n"));
    }

    public static String extractInsideCurlyBraces(String code) {
        int startIdx = code.indexOf(123);
        if (startIdx == -1) {
            return "";
        }
        int endIdx = code.lastIndexOf(125);
        return code.substring(startIdx + 1, endIdx);
    }

    public static String removeContentInsideBracketsInclusive(String code) {
        int openIdx = code.indexOf(60);
        return openIdx == -1 ? code : code.substring(0, openIdx);
    }

    private static Integer lineIndentation(String line) {
        int i;
        for (i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    public static String createIndentation(int numberOfSpaces) {
        return numberOfSpaces == 0 ? "" : String.format("%" + numberOfSpaces + "s", "");
    }

    public static String concatWithIndentation(String prefix, String multilineText) {
        String indentation = StringUtils.createIndentation(prefix.length());
        String[] lines = multilineText.split("\n");
        return prefix + lines[0] + (lines.length > 1 ? "\n" + Arrays.stream(lines).skip(1L).map(l -> indentation + l).collect(Collectors.joining("\n")) : "");
    }

    public static String removeQuotes(String text) {
        if ((text.startsWith("\"") || text.startsWith("'")) && text.endsWith("\"") || text.endsWith("'")) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    public static String wrapInDoubleQuotes(String text) {
        if (text.startsWith("\"") && text.endsWith("\"")) {
            return text;
        }
        return "\"" + text + "\"";
    }

    private static String removeIndentation(String line, Integer indentation) {
        if (line.trim().isEmpty()) {
            return line;
        }
        return line.substring(indentation);
    }

    private static boolean notEmptyLine(String s2) {
        return !s2.trim().isEmpty();
    }

    private static List<String> trimEmptyLines(List<String> lines) {
        int b = StringUtils.firstNonEmptyLineIdx(lines);
        int e = StringUtils.firstFromEndNonEmptyLineIdx(lines);
        return lines.subList(Math.max(b, 0), e > 0 ? e + 1 : lines.size());
    }

    private static int firstNonEmptyLineIdx(List<String> lines) {
        for (int i = 0; i < lines.size(); ++i) {
            if (!StringUtils.notEmptyLine(lines.get(i))) continue;
            return i;
        }
        return -1;
    }

    private static int firstFromEndNonEmptyLineIdx(List<String> lines) {
        for (int i = lines.size() - 1; i >= 0; --i) {
            if (!StringUtils.notEmptyLine(lines.get(i))) continue;
            return i;
        }
        return -1;
    }
}

