/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.website.markups;

import java.io.File;
import java.nio.file.Path;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParsingConfiguration;
import org.testingisdocumenting.znai.parser.commonmark.MarkdownParser;
import org.testingisdocumenting.znai.structure.PlainTextTocGenerator;
import org.testingisdocumenting.znai.structure.PlainTextTocPatcher;
import org.testingisdocumenting.znai.structure.TableOfContents;
import org.testingisdocumenting.znai.structure.TocItem;
import org.testingisdocumenting.znai.utils.FilePathUtils;

public class MarkdownParsingConfiguration
implements MarkupParsingConfiguration {
    public static final String TOC_PATCH_NAME = "toc-patch";

    @Override
    public String configurationName() {
        return "markdown";
    }

    @Override
    public TableOfContents createToc(String docTitle, ComponentsRegistry componentsRegistry) {
        TableOfContents toc = new PlainTextTocGenerator().generate(componentsRegistry.resourceResolver().textContent("toc"));
        toc.addIndex(docTitle);
        if (componentsRegistry.resourceResolver().canResolve(TOC_PATCH_NAME)) {
            String patch = componentsRegistry.resourceResolver().textContent(TOC_PATCH_NAME);
            new PlainTextTocPatcher(toc).patch(patch);
        }
        return toc;
    }

    @Override
    public MarkupParser createMarkupParser(ComponentsRegistry componentsRegistry) {
        return new MarkdownParser(componentsRegistry);
    }

    @Override
    public String tocItemResourceName(TocItem tocItem) {
        return tocItem.getDirName() + (tocItem.getDirName().isEmpty() ? "" : File.separator) + tocItem.getFileNameWithoutExtension() + "." + this.filesExtension();
    }

    @Override
    public Path fullPath(ComponentsRegistry componentsRegistry, Path root, TocItem tocItem) {
        return componentsRegistry.resourceResolver().fullPath(this.tocItemResourceName(tocItem));
    }

    @Override
    public TocItem tocItemByPath(ComponentsRegistry componentsRegistry, TableOfContents toc, Path path) {
        if (path.getFileName().toString().startsWith("index.")) {
            return toc.getIndex();
        }
        return toc.findTocItem(path.toAbsolutePath().getParent().getFileName().toString(), FilePathUtils.fileNameWithoutExtension(path));
    }

    private String filesExtension() {
        return "md";
    }
}

