/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http;

import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import znaishaded.io.vertx.codegen.annotations.CacheReturn;
import znaishaded.io.vertx.codegen.annotations.Fluent;
import znaishaded.io.vertx.codegen.annotations.GenIgnore;
import znaishaded.io.vertx.codegen.annotations.Nullable;
import znaishaded.io.vertx.codegen.annotations.VertxGen;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.MultiMap;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.http.Cookie;
import znaishaded.io.vertx.core.http.HttpConnection;
import znaishaded.io.vertx.core.http.HttpFrame;
import znaishaded.io.vertx.core.http.HttpMethod;
import znaishaded.io.vertx.core.http.HttpServerFileUpload;
import znaishaded.io.vertx.core.http.HttpServerResponse;
import znaishaded.io.vertx.core.http.HttpVersion;
import znaishaded.io.vertx.core.http.ServerWebSocket;
import znaishaded.io.vertx.core.http.StreamPriority;
import znaishaded.io.vertx.core.net.NetSocket;
import znaishaded.io.vertx.core.net.SocketAddress;
import znaishaded.io.vertx.core.streams.ReadStream;

@VertxGen
public interface HttpServerRequest
extends ReadStream<Buffer> {
    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> var1);

    public HttpServerRequest handler(Handler<Buffer> var1);

    public HttpServerRequest pause();

    public HttpServerRequest resume();

    public HttpServerRequest fetch(long var1);

    public HttpServerRequest endHandler(Handler<Void> var1);

    public HttpVersion version();

    public HttpMethod method();

    public String rawMethod();

    public boolean isSSL();

    public @Nullable String scheme();

    public String uri();

    public @Nullable String path();

    public @Nullable String query();

    public @Nullable String host();

    public long bytesRead();

    @CacheReturn
    public HttpServerResponse response();

    @CacheReturn
    public MultiMap headers();

    public @Nullable String getHeader(String var1);

    @GenIgnore(value={"permitted-type"})
    public String getHeader(CharSequence var1);

    @CacheReturn
    public MultiMap params();

    public @Nullable String getParam(String var1);

    @CacheReturn
    public SocketAddress remoteAddress();

    @CacheReturn
    public SocketAddress localAddress();

    @GenIgnore(value={"permitted-type"})
    public SSLSession sslSession();

    @GenIgnore
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException;

    public String absoluteURI();

    @Fluent
    default public HttpServerRequest bodyHandler(@Nullable Handler<Buffer> bodyHandler) {
        if (bodyHandler != null) {
            Buffer body = Buffer.buffer();
            this.handler(body::appendBuffer);
            this.endHandler(v -> bodyHandler.handle(body));
        }
        return this;
    }

    @CacheReturn
    public NetSocket netSocket();

    @Fluent
    public HttpServerRequest setExpectMultipart(boolean var1);

    public boolean isExpectMultipart();

    @Fluent
    public HttpServerRequest uploadHandler(@Nullable Handler<HttpServerFileUpload> var1);

    @CacheReturn
    public MultiMap formAttributes();

    public @Nullable String getFormAttribute(String var1);

    public ServerWebSocket upgrade();

    public boolean isEnded();

    @Fluent
    public HttpServerRequest customFrameHandler(Handler<HttpFrame> var1);

    @CacheReturn
    public HttpConnection connection();

    default public StreamPriority streamPriority() {
        return null;
    }

    @Fluent
    public HttpServerRequest streamPriorityHandler(Handler<StreamPriority> var1);

    public @Nullable Cookie getCookie(String var1);

    public int cookieCount();

    @GenIgnore
    public Map<String, Cookie> cookieMap();
}

