/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.fasterxml.jackson.databind.ObjectMapper;
import znaishaded.io.vertx.core.MultiMap;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.VertxException;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.json.JsonArray;
import znaishaded.io.vertx.core.json.JsonObject;
import znaishaded.io.vertx.ext.web.RoutingContext;

public class Utils
extends znaishaded.io.vertx.core.impl.Utils {
    private static final ZoneId ZONE_GMT = ZoneId.of("GMT");

    public static ClassLoader getClassLoader() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return tccl == null ? Utils.class.getClassLoader() : tccl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Buffer readResourceToBuffer(String resource) {
        ClassLoader cl = Utils.getClassLoader();
        try {
            Buffer buffer = Buffer.buffer();
            try (InputStream in = cl.getResourceAsStream(resource);){
                int read;
                if (in == null) {
                    Buffer buffer2 = null;
                    return buffer2;
                }
                byte[] data = new byte[4096];
                while ((read = in.read(data, 0, data.length)) != -1) {
                    if (read == data.length) {
                        buffer.appendBytes(data);
                        continue;
                    }
                    byte[] slice = new byte[read];
                    System.arraycopy(data, 0, slice, 0, slice.length);
                    buffer.appendBytes(slice);
                }
                return buffer;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static String readFileToString(Vertx vertx, String resource) {
        return Utils.readFileToString(vertx, resource, StandardCharsets.UTF_8);
    }

    public static String readFileToString(Vertx vertx, String resource, Charset charset) {
        try {
            Buffer buff = vertx.fileSystem().readFileBlocking(resource);
            return buff.toString(charset);
        }
        catch (Exception e) {
            throw new VertxException(e);
        }
    }

    public static String formatRFC1123DateTime(long time) {
        return DateTimeFormatter.RFC_1123_DATE_TIME.format(Instant.ofEpochMilli(time).atZone(ZONE_GMT));
    }

    public static long parseRFC1123DateTime(String header) {
        try {
            return header == null || header.isEmpty() ? -1L : LocalDateTime.parse(header, DateTimeFormatter.RFC_1123_DATE_TIME).toInstant(ZoneOffset.UTC).toEpochMilli();
        }
        catch (DateTimeParseException ex) {
            return -1L;
        }
    }

    public static String pathOffset(String path, RoutingContext context) {
        String routePath;
        int prefixLen = 0;
        String mountPoint = context.mountPoint();
        if (mountPoint != null) {
            prefixLen = mountPoint.length();
            if (mountPoint.charAt(mountPoint.length() - 1) == '/') {
                --prefixLen;
            }
        }
        if ((routePath = context.currentRoute().getPath()) != null) {
            prefixLen += routePath.length();
            if (routePath.charAt(routePath.length() - 1) == '/') {
                --prefixLen;
            }
        }
        return prefixLen != 0 ? path.substring(prefixLen) : path;
    }

    public static long secondsFactor(long millis) {
        return millis - millis % 1000L;
    }

    public static JsonNode toJsonNode(String object) {
        try {
            return new ObjectMapper().readTree(object);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JsonNode toJsonNode(JsonObject object) {
        try {
            return new ObjectMapper().readTree(object.encode());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JsonObject toJsonObject(JsonNode node) {
        return new JsonObject(node.toString());
    }

    public static JsonArray toJsonArray(JsonNode node) {
        return new JsonArray(node.toString());
    }

    public static Object toVertxJson(JsonNode node) {
        if (node.isArray()) {
            return Utils.toJsonArray(node);
        }
        if (node.isObject()) {
            return Utils.toJsonObject(node);
        }
        return node.toString();
    }

    public static boolean isJsonContentType(String contentType) {
        return contentType.contains("application/json") || contentType.contains("+json");
    }

    public static boolean isXMLContentType(String contentType) {
        return contentType.contains("application/xml") || contentType.contains("text/xml") || contentType.contains("+xml");
    }

    public static void addToMapIfAbsent(MultiMap map, String key, String value) {
        if (!map.contains(key)) {
            map.set(key, value);
        }
    }
}

