/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import znaishaded.net.sourceforge.plantuml.AFile;
import znaishaded.net.sourceforge.plantuml.AParentFolder;
import znaishaded.net.sourceforge.plantuml.AParentFolderZip;
import znaishaded.net.sourceforge.plantuml.security.SFile;

public class AFileZipEntry
implements AFile {
    private final SFile zipFile;
    private final String entry;

    public AFileZipEntry(SFile file, String entry) {
        this.zipFile = file;
        this.entry = entry;
    }

    public String toString() {
        return "AFileZipEntry::" + this.zipFile.getAbsolutePath() + " " + this.entry;
    }

    @Override
    public InputStream openFile() {
        InputStream tmp = this.zipFile.openFile();
        if (tmp != null) {
            try {
                ZipInputStream zis = new ZipInputStream(tmp);
                ZipEntry ze = zis.getNextEntry();
                while (ze != null) {
                    String fileName = ze.getName();
                    if (!ze.isDirectory() && fileName.trim().equalsIgnoreCase(this.entry.trim())) {
                        return zis;
                    }
                    ze = zis.getNextEntry();
                }
                zis.closeEntry();
                zis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public boolean isOk() {
        InputStream is;
        if (this.zipFile.exists() && !this.zipFile.isDirectory() && (is = this.openFile()) != null) {
            try {
                is.close();
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public int hashCode() {
        return this.zipFile.hashCode() + this.entry.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AFileZipEntry)) {
            return false;
        }
        AFileZipEntry other = (AFileZipEntry)obj;
        return this.zipFile.equals(other.zipFile) && this.entry.equals(other.entry);
    }

    @Override
    public AParentFolder getParentFile() {
        return new AParentFolderZip(this.zipFile, this.entry);
    }

    @Override
    public SFile getUnderlyingFile() {
        return this.zipFile;
    }

    @Override
    public SFile getSystemFolder() throws IOException {
        return this.zipFile.getParentFile().getCanonicalFile();
    }
}

