/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.Direction;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.asciiart.Wcwidth;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;

public class StringUtils {
    public static final List<String> getSplit(Pattern2 pattern, String line) {
        Matcher2 m3 = pattern.matcher(line);
        if (!m3.find()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 1; i <= m3.groupCount(); ++i) {
            result.add(m3.group(i));
        }
        return result;
    }

    public static boolean isNotEmpty(String input) {
        return input != null && StringUtils.trin(input).length() > 0;
    }

    public static boolean isNotEmpty(List<? extends CharSequence> input) {
        return input != null && input.size() > 0;
    }

    public static boolean isEmpty(String input) {
        return input == null || StringUtils.trin(input).length() == 0;
    }

    public static String manageHtml(String s2) {
        s2 = s2.replace("<", "&lt;");
        s2 = s2.replace(">", "&gt;");
        return s2;
    }

    public static String unicode(String s2) {
        StringBuilder result = new StringBuilder();
        for (char c : s2.toCharArray()) {
            if (c > '\u007f' || c == '&' || c == '|') {
                char i = c;
                result.append("&#" + i + ";");
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String unicodeForHtml(String s2) {
        StringBuilder result = new StringBuilder();
        for (char c : s2.toCharArray()) {
            if (c > '\u007f' || c == '&' || c == '|' || c == '<' || c == '>') {
                char i = c;
                result.append("&#" + i + ";");
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String unicodeForHtml(Display display) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < display.size(); ++i) {
            result.append(StringUtils.unicodeForHtml(display.get(i).toString()));
            if (i >= display.size() - 1) continue;
            result.append("<br>");
        }
        return result.toString();
    }

    public static String manageArrowForSequence(String s2) {
        s2 = s2.replace('=', '-').toLowerCase();
        return s2;
    }

    public static String capitalize(String s2) {
        return s2.substring(0, 1).toUpperCase() + s2.substring(1).toLowerCase();
    }

    public static String goUpperCase(String s2) {
        return s2.toUpperCase(Locale.ENGLISH);
    }

    public static char goUpperCase(char c) {
        return StringUtils.goUpperCase("" + c).charAt(0);
    }

    public static String goLowerCase(String s2) {
        return s2.toLowerCase(Locale.ENGLISH);
    }

    public static char goLowerCase(char c) {
        return StringUtils.goLowerCase("" + c).charAt(0);
    }

    public static String manageArrowForCuca(String s2) {
        Direction dir = StringUtils.getArrowDirection(s2);
        s2 = s2.replace('=', '-');
        s2 = s2.replaceAll("\\w*", "");
        if (dir == Direction.LEFT || dir == Direction.RIGHT) {
            s2 = s2.replaceAll("-+", "-");
        }
        if (s2.length() == 2 && (dir == Direction.UP || dir == Direction.DOWN)) {
            s2 = s2.replaceFirst("-", "--");
        }
        return s2;
    }

    public static String manageQueueForCuca(String s2) {
        Direction dir = StringUtils.getQueueDirection(s2);
        s2 = s2.replace('=', '-');
        s2 = s2.replaceAll("\\w*", "");
        if (dir == Direction.LEFT || dir == Direction.RIGHT) {
            s2 = s2.replaceAll("-+", "-");
        }
        if (s2.length() == 1 && (dir == Direction.UP || dir == Direction.DOWN)) {
            s2 = s2.replaceFirst("-", "--");
        }
        return s2;
    }

    public static Direction getArrowDirection(String s2) {
        if (s2.endsWith(">")) {
            return StringUtils.getQueueDirection(s2.substring(0, s2.length() - 1));
        }
        if (s2.startsWith("<")) {
            if (s2.length() == 2) {
                return Direction.LEFT;
            }
            return Direction.UP;
        }
        throw new IllegalArgumentException(s2);
    }

    public static Direction getQueueDirection(String s2) {
        if (s2.indexOf(60) != -1 || s2.indexOf(62) != -1) {
            throw new IllegalArgumentException(s2);
        }
        if ((s2 = s2.toLowerCase()).contains("left")) {
            return Direction.LEFT;
        }
        if (s2.contains("right")) {
            return Direction.RIGHT;
        }
        if (s2.contains("up")) {
            return Direction.UP;
        }
        if (s2.contains("down")) {
            return Direction.DOWN;
        }
        if (s2.contains("l")) {
            return Direction.LEFT;
        }
        if (s2.contains("r")) {
            return Direction.RIGHT;
        }
        if (s2.contains("u")) {
            return Direction.UP;
        }
        if (s2.contains("d")) {
            return Direction.DOWN;
        }
        if (s2.length() == 1) {
            return Direction.RIGHT;
        }
        return Direction.DOWN;
    }

    public static String eventuallyRemoveStartingAndEndingDoubleQuote(String s2, String format) {
        if (s2 == null) {
            return null;
        }
        if (format.contains("\"") && s2.length() > 1 && StringUtils.isDoubleQuote(s2.charAt(0)) && StringUtils.isDoubleQuote(s2.charAt(s2.length() - 1))) {
            return s2.substring(1, s2.length() - 1);
        }
        if (format.contains("(") && s2.startsWith("(") && s2.endsWith(")")) {
            return s2.substring(1, s2.length() - 1);
        }
        if (format.contains("[") && s2.startsWith("[") && s2.endsWith("]")) {
            return s2.substring(1, s2.length() - 1);
        }
        if (format.contains(":") && s2.startsWith(":") && s2.endsWith(":")) {
            return s2.substring(1, s2.length() - 1);
        }
        return s2;
    }

    public static String eventuallyRemoveStartingAndEndingDoubleQuote(String s2) {
        if (s2 == null) {
            return s2;
        }
        return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(s2, "\"([:");
    }

    private static boolean isDoubleQuote(char c) {
        return c == '\"' || c == '\u201c' || c == '\u201d' || c == '\u00ab' || c == '\u00bb';
    }

    public static boolean isCJK(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        Log.println("block=" + block);
        return false;
    }

    public static char hiddenLesserThan() {
        return '\u0005';
    }

    public static char hiddenBiggerThan() {
        return '\u0006';
    }

    public static String hideComparatorCharacters(String s2) {
        s2 = s2.replace('<', StringUtils.hiddenLesserThan());
        s2 = s2.replace('>', StringUtils.hiddenBiggerThan());
        return s2;
    }

    public static String showComparatorCharacters(String s2) {
        s2 = s2.replace(StringUtils.hiddenLesserThan(), '<');
        s2 = s2.replace(StringUtils.hiddenBiggerThan(), '>');
        return s2;
    }

    private static int getWidth(Display stringsToDisplay) {
        int result = 1;
        for (CharSequence s2 : stringsToDisplay) {
            if (s2 == null || result >= s2.length()) continue;
            result = s2.length();
        }
        return result;
    }

    public static int getWcWidth(Display stringsToDisplay) {
        int result = 1;
        for (CharSequence s2 : stringsToDisplay) {
            int length;
            if (s2 == null || result >= (length = Wcwidth.length(s2))) continue;
            result = length;
        }
        return result;
    }

    public static int getHeight(List<? extends CharSequence> stringsToDisplay) {
        return stringsToDisplay.size();
    }

    public static int getHeight(Display stringsToDisplay) {
        return stringsToDisplay.size();
    }

    public static boolean isDiagramCacheable(String uml) {
        return uml.length() >= 35;
    }

    public static int getPragmaRevision(String uml) {
        int x1;
        int x2;
        uml = uml.toLowerCase();
        String header = "@startuml\n!pragma revision ";
        if (!uml.startsWith("@startuml\n!pragma revision ")) {
            return -1;
        }
        for (x2 = x1 = "@startuml\n!pragma revision ".length(); x2 < uml.length() && Character.isDigit(uml.charAt(x2)); ++x2) {
        }
        if (x1 == x2) {
            return -1;
        }
        return Integer.parseInt(uml.substring(x1, x2));
    }

    public static List<String> splitComma(String s2) {
        s2 = StringUtils.trin(s2);
        ArrayList<String> result = new ArrayList<String>();
        Pattern2 p = MyPattern.cmpile("([\\p{L}0-9_.]+|[%g][^%g]+[%g])");
        Matcher2 m3 = p.matcher(s2);
        while (m3.find()) {
            result.add(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(m3.group(0)));
        }
        return Collections.unmodifiableList(result);
    }

    public static String getUid(String uid1, int uid2) {
        return uid1 + String.format("%04d", uid2);
    }

    public static <O> List<O> merge(List<O> l1, List<O> l2) {
        ArrayList<O> result = new ArrayList<O>(l1);
        result.addAll(l2);
        return Collections.unmodifiableList(result);
    }

    public static boolean endsWithBackslash(String s2) {
        return s2.endsWith("\\") && !s2.endsWith("\\\\");
    }

    public static String rot(String s2) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c >= 'a' && c <= 'm' || c >= 'A' && c <= 'M') {
                c = (char)(c + 13);
            } else if (c >= 'n' && c <= 'z' || c >= 'N' && c <= 'Z') {
                c = (char)(c - 13);
            } else if (c > '~') {
                throw new IllegalArgumentException(s2);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String manageUnicodeNotationUplus(String s2) {
        Pattern pattern = Pattern.compile("\\<U\\+([0-9a-fA-F]{4,5})\\>");
        Matcher matcher = pattern.matcher(s2);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String num = matcher.group(1);
            int value = Integer.parseInt(num, 16);
            String replace = new String(Character.toChars(value));
            matcher.appendReplacement(result, Matcher.quoteReplacement(replace));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static String manageAmpDiese(String s2) {
        Pattern pattern = Pattern.compile("\\&#([0-9]+);");
        Matcher matcher = pattern.matcher(s2);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String num = matcher.group(1);
            char c = (char)Integer.parseInt(num);
            matcher.appendReplacement(result, "" + c);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static String manageTildeArobaseStart(String s2) {
        s2 = s2.replaceAll("~@start", "@start");
        return s2;
    }

    public static String trinNoTrace(CharSequence s2) {
        return s2.toString().trim();
    }

    public static String trin(String arg) {
        if (arg.length() == 0) {
            return arg;
        }
        return StringUtils.trinEndingInternal(arg, StringUtils.getPositionStartNonSpace(arg));
    }

    private static int getPositionStartNonSpace(String arg) {
        int i;
        for (i = 0; i < arg.length() && StringUtils.isSpaceOrTabOrNull(arg.charAt(i)); ++i) {
        }
        return i;
    }

    private static String trinEnding(String arg) {
        if (arg.length() == 0) {
            return arg;
        }
        return StringUtils.trinEndingInternal(arg, 0);
    }

    private static String trinEndingInternal(String arg, int from) {
        int j;
        for (j = arg.length() - 1; j >= from && StringUtils.isSpaceOrTabOrNull(arg.charAt(j)); --j) {
        }
        if (from == 0 && j == arg.length() - 1) {
            return arg;
        }
        return arg.substring(from, j + 1);
    }

    private static boolean isSpaceOrTabOrNull(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\u0000';
    }
}

