/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.creole.Stencil;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;

public class Diamond {
    public static final double diamondHalfSize = 12.0;

    public static UPolygon asPolygon(double shadowing) {
        UPolygon diams = new UPolygon();
        diams.addPoint(12.0, 0.0);
        diams.addPoint(24.0, 12.0);
        diams.addPoint(12.0, 24.0);
        diams.addPoint(0.0, 12.0);
        diams.addPoint(12.0, 0.0);
        diams.setDeltaShadow(shadowing);
        return diams;
    }

    public static UPolygon asPolygon(double shadowing, double width, double height) {
        UPolygon diams = new UPolygon();
        diams.addPoint(12.0, 0.0);
        diams.addPoint(width - 12.0, 0.0);
        diams.addPoint(width, height / 2.0);
        diams.addPoint(width - 12.0, height);
        diams.addPoint(12.0, height);
        diams.addPoint(0.0, height / 2.0);
        diams.addPoint(12.0, 0.0);
        diams.setDeltaShadow(shadowing);
        return diams;
    }

    public static Stencil asStencil(final TextBlock tb) {
        return new Stencil(){

            private final double getDeltaX(double height, double y) {
                double p = y / height * 2.0;
                if (p <= 1.0) {
                    return 12.0 * p;
                }
                return 12.0 * (2.0 - p);
            }

            @Override
            public double getStartingX(StringBounder stringBounder, double y) {
                Dimension2D dim = tb.calculateDimension(stringBounder);
                return -this.getDeltaX(dim.getHeight(), y);
            }

            @Override
            public double getEndingX(StringBounder stringBounder, double y) {
                Dimension2D dim = tb.calculateDimension(stringBounder);
                return dim.getWidth() + this.getDeltaX(dim.getHeight(), y);
            }
        };
    }

    public static UPolygon asPolygonFoo1(boolean shadowing, double width, double height) {
        UPolygon diams = new UPolygon();
        diams.addPoint(width / 2.0, 0.0);
        diams.addPoint(width, height / 2.0);
        diams.addPoint(width / 2.0, height);
        diams.addPoint(0.0, height / 2.0);
        if (shadowing) {
            diams.setDeltaShadow(3.0);
        }
        return diams;
    }
}

