/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.classdiagram.command;

import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IEntity;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Ident;

public class CommandUrl
extends SingleLineCommand2<AbstractEntityDiagram> {
    public CommandUrl() {
        super(CommandUrl.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandUrl.class.getName(), RegexLeaf.start(), new RegexLeaf("url"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("of|for")), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE", "([\\p{L}0-9_.]+|[%g][^%g]+[%g])"), RegexLeaf.spaceOneOrMore(), new RegexOptional((IRegex)new RegexLeaf("is")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractEntityDiagram diagram, LineLocation location, RegexResult arg) {
        IEntity entity;
        boolean leafExist;
        String idShort = arg.get("CODE", 0);
        Ident ident = diagram.buildLeafIdent(idShort);
        Ident code = diagram.V1972() ? ident : diagram.buildCode(idShort);
        String urlString = arg.get("URL", 0);
        boolean bl = leafExist = diagram.V1972() ? diagram.leafExistSmart(ident) : diagram.leafExist(code);
        if (leafExist) {
            entity = diagram.getOrCreateLeaf(ident, code, null, null);
        } else if (diagram.V1972() ? diagram.isGroupStrict(ident) : diagram.isGroup(code)) {
            entity = diagram.V1972() ? diagram.getGroupStrict(ident) : diagram.getGroup(code);
        } else {
            return CommandExecutionResult.error(code + " does not exist");
        }
        UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
        Url url = urlBuilder.getUrl(urlString);
        entity.addUrl(url);
        return CommandExecutionResult.ok();
    }
}

