/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole.legacy;

import java.awt.font.LineMetrics;
import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.BackSlash;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.LineBreakStrategy;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.creole.Parser;
import znaishaded.net.sourceforge.plantuml.creole.atom.AbstractAtom;
import znaishaded.net.sourceforge.plantuml.creole.atom.Atom;
import znaishaded.net.sourceforge.plantuml.creole.atom.AtomHorizontalTexts;
import znaishaded.net.sourceforge.plantuml.creole.atom.AtomImg;
import znaishaded.net.sourceforge.plantuml.creole.atom.AtomOpenIcon;
import znaishaded.net.sourceforge.plantuml.creole.atom.AtomSprite;
import znaishaded.net.sourceforge.plantuml.creole.atom.AtomVerticalTexts;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.ImgValign;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.openiconic.OpenIcon;
import znaishaded.net.sourceforge.plantuml.sprite.Sprite;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UText;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorAutomatic;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSimple;
import znaishaded.net.sourceforge.plantuml.utils.CharHidder;

public class AtomText
extends AbstractAtom
implements Atom {
    private static DelayedDouble ZERO = new DelayedDouble(){

        @Override
        public double getDouble(StringBounder stringBounder) {
            return 0.0;
        }
    };
    private final FontConfiguration fontConfiguration;
    private final String text;
    private final DelayedDouble marginLeft;
    private final DelayedDouble marginRight;
    private final Url url;

    public static Atom create(String text, FontConfiguration fontConfiguration) {
        return new AtomText(text, fontConfiguration, null, ZERO, ZERO);
    }

    public static Atom createUrl(Url url, FontConfiguration fontConfiguration, ISkinSimple skinSimple) {
        fontConfiguration = fontConfiguration.hyperlink();
        Display display = Display.getWithNewlines(url.getLabel());
        if (display.size() > 1) {
            ArrayList<Atom> all = new ArrayList<Atom>();
            for (CharSequence charSequence : display.as()) {
                all.add(AtomText.createAtomText(charSequence.toString(), url, fontConfiguration, skinSimple));
            }
            return new AtomVerticalTexts(all);
        }
        return AtomText.createAtomText(url.getLabel(), url, fontConfiguration, skinSimple);
    }

    private static Atom createAtomText(String text, Url url, FontConfiguration fontConfiguration, ISkinSimple skinSimple) {
        StringBuffer sb;
        Pattern p = Pattern.compile("\\<&([-\\w]+)([\\{,]?(?:(?:scale=|\\*)[0-9.]+)?(?:,color[= :](?:#[0-9a-fA-F]{6}|\\w+))?\\}?)?\\>|\\<\\$([-\\p{L}0-9_/]+)([\\{,]?(?:(?:scale=|\\*)[0-9.]+)?(?:,color[= :](?:#[0-9a-fA-F]{6}|\\w+))?\\}?)?\\>|\\<img[\\s:]+([^>{}]+)(\\{scale=(?:[0-9.]+)\\})?\\>");
        Matcher m3 = p.matcher(text);
        ArrayList<Atom> result = new ArrayList<Atom>();
        while (m3.find()) {
            double scale;
            sb = new StringBuffer();
            m3.appendReplacement(sb, "");
            if (sb.length() > 0) {
                result.add(new AtomText(sb.toString(), fontConfiguration, url, ZERO, ZERO));
            }
            String valOpenicon = m3.group(1);
            String valSprite = m3.group(3);
            String valImg = m3.group(5);
            if (valOpenicon != null) {
                OpenIcon openIcon = OpenIcon.retrieve(valOpenicon);
                if (openIcon == null) continue;
                scale = Parser.getScale(m3.group(2), 1.0);
                result.add(new AtomOpenIcon(null, scale, openIcon, fontConfiguration, url));
                continue;
            }
            if (valSprite != null) {
                Sprite sprite = skinSimple.getSprite(valSprite);
                if (sprite == null) continue;
                scale = Parser.getScale(m3.group(4), 1.0);
                result.add(new AtomSprite(null, scale, fontConfiguration, sprite, url));
                continue;
            }
            if (valImg == null) continue;
            double scale2 = Parser.getScale(m3.group(6), 1.0);
            result.add(AtomImg.create(valImg, ImgValign.TOP, 0, scale2, url));
        }
        sb = new StringBuffer();
        m3.appendTail(sb);
        if (sb.length() > 0) {
            result.add(new AtomText(sb.toString(), fontConfiguration, url, ZERO, ZERO));
        }
        if (result.size() == 1) {
            return (Atom)result.get(0);
        }
        return new AtomHorizontalTexts(result);
    }

    public static Atom createListNumber(final FontConfiguration fontConfiguration, final int order, int localNumber) {
        DelayedDouble left = new DelayedDouble(){

            @Override
            public double getDouble(StringBounder stringBounder) {
                Dimension2D dim = stringBounder.calculateDimension(fontConfiguration.getFont(), "9. ");
                return dim.getWidth() * (double)order;
            }
        };
        DelayedDouble right = new DelayedDouble(){

            @Override
            public double getDouble(StringBounder stringBounder) {
                Dimension2D dim = stringBounder.calculateDimension(fontConfiguration.getFont(), ".");
                return dim.getWidth();
            }
        };
        return new AtomText("" + (localNumber + 1) + ".", fontConfiguration, null, left, right);
    }

    public String toString() {
        return this.text + " " + this.fontConfiguration;
    }

    private AtomText(String text, FontConfiguration style, Url url, DelayedDouble marginLeft, DelayedDouble marginRight) {
        if (text.contains("" + BackSlash.hiddenNewLine())) {
            throw new IllegalArgumentException(text);
        }
        this.marginLeft = marginLeft;
        this.marginRight = marginRight;
        this.text = StringUtils.manageTildeArobaseStart(StringUtils.manageUnicodeNotationUplus(StringUtils.manageAmpDiese(StringUtils.showComparatorCharacters(CharHidder.unhide(text)))));
        this.fontConfiguration = style;
        this.url = url;
    }

    public FontConfiguration getFontConfiguration() {
        return this.fontConfiguration;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D rect = stringBounder.calculateDimension(this.fontConfiguration.getFont(), this.text);
        Log.debug("g2d=" + rect);
        Log.debug("Size for " + this.text + " is " + rect);
        double h2 = rect.getHeight();
        if (h2 < 10.0) {
            h2 = 10.0;
        }
        double width = this.text.indexOf(9) == -1 ? rect.getWidth() : this.getWidth(stringBounder);
        double left = this.marginLeft.getDouble(stringBounder);
        double right = this.marginRight.getDouble(stringBounder);
        return new Dimension2DDouble(width + left + right, h2);
    }

    private double getDescent() {
        LineMetrics fm = TextBlockUtils.getLineMetrics(this.fontConfiguration.getFont(), this.text);
        double descent = fm.getDescent();
        return descent;
    }

    public double getFontSize2D() {
        return this.fontConfiguration.getFont().getSize2D();
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return this.fontConfiguration.getSpace();
    }

    private double getTabSize(StringBounder stringBounder) {
        return stringBounder.calculateDimension(this.fontConfiguration.getFont(), this.tabString()).getWidth();
    }

    private String tabString() {
        int nb = this.fontConfiguration.getTabSize();
        if (nb >= 1 && nb < 7) {
            return "        ".substring(0, nb);
        }
        return "        ";
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        if (ug.matchesProperty("SPECIALTXT")) {
            ug.draw(this);
        } else {
            HColor textColor = this.fontConfiguration.getColor();
            FontConfiguration useFontConfiguration = this.fontConfiguration;
            if (textColor instanceof HColorAutomatic && ug.getParam().getBackcolor() != null) {
                textColor = ((HColorSimple)ug.getParam().getBackcolor()).opposite();
                useFontConfiguration = this.fontConfiguration.changeColor(textColor);
            }
            if (this.marginLeft != ZERO) {
                ug = ug.apply(UTranslate.dx(this.marginLeft.getDouble(ug.getStringBounder())));
            }
            StringTokenizer tokenizer = new StringTokenizer(this.text, "\t", true);
            double x = 0.0;
            Dimension2D rect = ug.getStringBounder().calculateDimension(this.fontConfiguration.getFont(), this.text);
            double descent = this.getDescent();
            double ypos = rect.getHeight() - descent;
            if (tokenizer.hasMoreTokens()) {
                double tabSize = this.getTabSize(ug.getStringBounder());
                while (tokenizer.hasMoreTokens()) {
                    String s2 = tokenizer.nextToken();
                    if (s2.equals("\t")) {
                        double remainder = x % tabSize;
                        x += tabSize - remainder;
                        continue;
                    }
                    UText utext = new UText(s2, useFontConfiguration);
                    Dimension2D dim = ug.getStringBounder().calculateDimension(this.fontConfiguration.getFont(), s2);
                    ug.apply(new UTranslate(x, ypos)).draw(utext);
                    x += dim.getWidth();
                }
            }
        }
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    private double getWidth(StringBounder stringBounder) {
        return this.getWidth(stringBounder, this.text);
    }

    private double getWidth(StringBounder stringBounder, String text) {
        StringTokenizer tokenizer = new StringTokenizer(text, "\t", true);
        double tabSize = this.getTabSize(stringBounder);
        double x = 0.0;
        while (tokenizer.hasMoreTokens()) {
            String s2 = tokenizer.nextToken();
            if (s2.equals("\t")) {
                double remainder = x % tabSize;
                x += tabSize - remainder;
                continue;
            }
            Dimension2D dim = stringBounder.calculateDimension(this.fontConfiguration.getFont(), s2);
            x += dim.getWidth();
        }
        return x;
    }

    public List<AtomText> getSplitted(StringBounder stringBounder, LineBreakStrategy maxWidthAsString) {
        double maxWidth = maxWidthAsString.getMaxWidth();
        if (maxWidth == 0.0) {
            throw new IllegalStateException();
        }
        ArrayList<AtomText> result = new ArrayList<AtomText>();
        StringTokenizer st = new StringTokenizer(this.text, " ", true);
        StringBuilder currentLine = new StringBuilder();
        while (st.hasMoreTokens()) {
            String token1 = st.nextToken();
            for (String tmp : this.splitLong1(stringBounder, maxWidth, token1)) {
                double w = this.getWidth(stringBounder, currentLine + tmp);
                if (w > maxWidth) {
                    result.add(new AtomText(currentLine.toString(), this.fontConfiguration, this.url, this.marginLeft, this.marginRight));
                    currentLine.setLength(0);
                    if (tmp.startsWith(" ")) continue;
                    currentLine.append(tmp);
                    continue;
                }
                currentLine.append(tmp);
            }
        }
        result.add(new AtomText(currentLine.toString(), this.fontConfiguration, this.url, this.marginLeft, this.marginRight));
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Atom> splitInTwo(StringBounder stringBounder, double width) {
        StringBuilder tmp = new StringBuilder();
        for (String token : this.splitted()) {
            if (tmp.length() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                if (this.getWidth(stringBounder, stringBuilder.append(tmp.toString()).append(token).toString()) > width) {
                    AtomText part1 = new AtomText(tmp.toString(), this.fontConfiguration, this.url, this.marginLeft, this.marginRight);
                    String remain = this.text.substring(tmp.length());
                    while (remain.startsWith(" ")) {
                        remain = remain.substring(1);
                    }
                    AtomText part2 = new AtomText(remain, this.fontConfiguration, this.url, this.marginLeft, this.marginRight);
                    return Arrays.asList(part1, part2);
                }
            }
            tmp.append(token);
        }
        return Collections.singletonList(this);
    }

    private Collection<String> splitted() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.text.length(); ++i) {
            char ch = this.text.charAt(i);
            if (Character.isLetter(ch)) {
                StringBuilder tmp = new StringBuilder();
                tmp.append(ch);
                while (i + 1 < this.text.length() && Character.isLetter(this.text.charAt(i + 1))) {
                    tmp.append(this.text.charAt(++i));
                }
                result.add(tmp.toString());
                continue;
            }
            result.add("" + this.text.charAt(i));
        }
        return result;
    }

    private Collection<String> splittedOld() {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(this.text, " ", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            result.add(token);
        }
        return result;
    }

    private List<Atom> splitInTwoOld(StringBounder stringBounder, double width) {
        StringTokenizer st = new StringTokenizer(this.text, " ", true);
        StringBuilder tmp = new StringBuilder();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (tmp.length() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                if (this.getWidth(stringBounder, stringBuilder.append(tmp.toString()).append(token).toString()) > width) {
                    AtomText part1 = new AtomText(tmp.toString(), this.fontConfiguration, this.url, this.marginLeft, this.marginRight);
                    String remain = this.text.substring(tmp.length());
                    while (remain.startsWith(" ")) {
                        remain = remain.substring(1);
                    }
                    AtomText part2 = new AtomText(remain, this.fontConfiguration, this.url, this.marginLeft, this.marginRight);
                    return Arrays.asList(part1, part2);
                }
            }
            tmp.append(token);
        }
        return Collections.singletonList(this);
    }

    private List<String> splitLong1(StringBounder stringBounder, double maxWidth, String add) {
        return Arrays.asList(add);
    }

    public final String getText() {
        return this.text;
    }

    static interface DelayedDouble {
        public double getDouble(StringBounder var1);
    }
}

