/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram;

import java.util.EnumMap;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;

public class DisplaySection {
    private final Map<HorizontalAlignment, Display> map = new EnumMap<HorizontalAlignment, Display>(HorizontalAlignment.class);

    private DisplaySection() {
    }

    public DisplaySection withPage(int page, int lastpage) {
        DisplaySection result = new DisplaySection();
        for (Map.Entry<HorizontalAlignment, Display> ent : this.map.entrySet()) {
            result.map.put(ent.getKey(), ent.getValue().withPage(page, lastpage));
        }
        return result;
    }

    public Display getDisplay() {
        if (this.map.size() == 0) {
            return null;
        }
        return this.map.values().iterator().next();
    }

    public static DisplaySection none() {
        return new DisplaySection();
    }

    public final HorizontalAlignment getHorizontalAlignment() {
        if (this.map.size() == 0) {
            return HorizontalAlignment.CENTER;
        }
        return this.map.keySet().iterator().next();
    }

    public boolean isNull() {
        if (this.map.size() == 0) {
            return true;
        }
        Display display = this.map.values().iterator().next();
        return Display.isNull(display);
    }

    public TextBlock createRibbon(FontConfiguration fontConfiguration, ISkinSimple spriteContainer) {
        if (this.map.size() == 0) {
            return null;
        }
        Display display = this.map.values().iterator().next();
        if (Display.isNull(display) || display.size() == 0) {
            return null;
        }
        return display.create(fontConfiguration, this.getHorizontalAlignment(), spriteContainer);
    }

    public void putDisplay(Display display, HorizontalAlignment horizontalAlignment) {
        this.map.put(horizontalAlignment, display);
    }
}

