/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.error;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.AbstractPSystem;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.ErrorUml;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.SpriteContainerEmpty;
import znaishaded.net.sourceforge.plantuml.StringLocated;
import znaishaded.net.sourceforge.plantuml.api.ImageDataAbstract;
import znaishaded.net.sourceforge.plantuml.api.ImageDataSimple;
import znaishaded.net.sourceforge.plantuml.asciiart.UmlCharArea;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.eggs.PSystemWelcome;
import znaishaded.net.sourceforge.plantuml.flashcode.FlashCodeFactory;
import znaishaded.net.sourceforge.plantuml.flashcode.FlashCodeUtils;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.GraphicPosition;
import znaishaded.net.sourceforge.plantuml.graphic.GraphicStrings;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.InnerStrategy;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockRaw;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.security.SecurityUtils;
import znaishaded.net.sourceforge.plantuml.svek.GraphvizCrash;
import znaishaded.net.sourceforge.plantuml.svek.TextBlockBackcolored;
import znaishaded.net.sourceforge.plantuml.ugraphic.AffineTransformType;
import znaishaded.net.sourceforge.plantuml.ugraphic.ImageBuilder;
import znaishaded.net.sourceforge.plantuml.ugraphic.MinMax;
import znaishaded.net.sourceforge.plantuml.ugraphic.PixelImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSimple;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;
import znaishaded.net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;
import znaishaded.net.sourceforge.plantuml.version.LicenseInfo;
import znaishaded.net.sourceforge.plantuml.version.PSystemVersion;
import znaishaded.net.sourceforge.plantuml.version.Version;

public abstract class PSystemError
extends AbstractPSystem {
    protected List<StringLocated> trace;
    protected ErrorUml singleError;

    protected final StringLocated getLastLine() {
        return this.trace.get(this.trace.size() - 1);
    }

    public final LineLocation getLineLocation() {
        return this.getLastLine().getLocation();
    }

    public final Collection<ErrorUml> getErrorsUml() {
        return Collections.singleton(this.singleError);
    }

    @Override
    public final String getWarningOrError() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDescription());
        sb.append('\n');
        for (CharSequence t : this.getTitle().getDisplay()) {
            sb.append(t);
            sb.append('\n');
        }
        sb.append('\n');
        return sb.toString();
    }

    private TextBlockBackcolored getGraphicalFormatted() {
        FontConfiguration fc0 = GraphicStrings.sansSerif14(HColorUtils.BLACK).bold();
        FontConfiguration fc1 = GraphicStrings.sansSerif14(HColorUtils.MY_GREEN).bold();
        FontConfiguration fc2 = GraphicStrings.sansSerif14(HColorUtils.RED).bold();
        FontConfiguration fc4 = GraphicStrings.sansSerif12(HColorUtils.MY_GREEN).bold().italic();
        List<String> fullBody = this.getTextFullBody();
        TextBlockBackcolored result0 = TextBlockUtils.addBackcolor(TextBlockUtils.withMargin(new TextBlockRaw(this.getTextFromStack(), fc0), 1.0, 1.0, 1.0, 4.0), HColorUtils.MY_GREEN);
        TextBlockRaw result1 = new TextBlockRaw(this.allButLast(fullBody), fc1);
        TextBlockRaw result2 = new TextBlockRaw(this.onlyLast(fullBody), fc1.wave(HColorUtils.RED));
        TextBlockRaw result3 = new TextBlockRaw(this.getTextError(), fc2);
        TextBlock result4 = TextBlockUtils.withMargin(new TextBlockRaw(this.header(), fc4), 0.0, 2.0, 0.0, 8.0);
        TextBlock result = result0;
        result = TextBlockUtils.mergeTB(result, result1, HorizontalAlignment.LEFT);
        result = TextBlockUtils.mergeTB(result, result2, HorizontalAlignment.LEFT);
        result = TextBlockUtils.mergeTB(result, result3, HorizontalAlignment.LEFT);
        result = TextBlockUtils.mergeTB(result4, result, HorizontalAlignment.LEFT);
        result = TextBlockUtils.withMargin(result, 5.0, 5.0);
        return TextBlockUtils.addBackcolor(result, HColorUtils.BLACK);
    }

    private List<String> header() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("PlantUML " + Version.versionString());
        GraphvizCrash.checkOldVersionWarning(result);
        return result;
    }

    private List<String> getPureAsciiFormatted() {
        List<String> result = this.getTextFromStack();
        result.addAll(this.getTextFullBody());
        result.add("^^^^^");
        result.addAll(this.getTextError());
        return result;
    }

    private List<String> getTextFromStack() {
        LineLocation lineLocation = this.getLineLocation();
        ArrayList<String> result = new ArrayList<String>();
        if (lineLocation != null) {
            this.append(result, lineLocation);
            while (lineLocation.getParent() != null) {
                lineLocation = lineLocation.getParent();
                this.append(result, lineLocation);
            }
        }
        return result;
    }

    private List<String> getTextFullBody() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(" ");
        int traceSize = this.trace.size();
        if (traceSize > 40) {
            for (StringLocated stringLocated : this.trace.subList(0, 5)) {
                this.addToResult(result, stringLocated);
            }
            result.add("...");
            int skipped = traceSize - 5 - 20;
            result.add("... ( skipping " + skipped + " lines )");
            result.add("...");
            for (StringLocated s3 : this.trace.subList(traceSize - 20, traceSize)) {
                this.addToResult(result, s3);
            }
        } else {
            for (StringLocated stringLocated : this.trace) {
                this.addToResult(result, stringLocated);
            }
        }
        return result;
    }

    private void addToResult(List<String> result, StringLocated s2) {
        String tmp = s2.getString();
        if (tmp.length() > 120) {
            tmp = tmp.substring(0, 120) + " ...";
        }
        result.add(tmp);
    }

    private List<String> getTextError() {
        return Arrays.asList(" " + this.singleError.getError());
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        if (fileFormat.getFileFormat() == FileFormat.ATXT || fileFormat.getFileFormat() == FileFormat.UTXT) {
            UGraphicTxt ugt = new UGraphicTxt();
            UmlCharArea area = ugt.getCharArea();
            area.drawStringsLR(this.getPureAsciiFormatted(), 0, 0);
            area.print(SecurityUtils.createPrintStream(os));
            return new ImageDataSimple(1, 1);
        }
        TextBlockBackcolored result = this.getGraphicalFormatted();
        ImageBuilder imageBuilder = ImageBuilder.buildA(new ColorMapperIdentity(), false, null, this.getMetadata(), null, 1.0, result.getBackcolor());
        imageBuilder.setRandomPixel(true);
        TextBlock udrawable = this.getSource().getTotalLineCount() < 5 ? this.addWelcome(result) : result;
        int min2 = (int)(System.currentTimeMillis() / 60000L) % 60;
        if (min2 == 1 || min2 == 8 || min2 == 13 || min2 == 55) {
            udrawable = this.addMessagePatreon(udrawable);
        } else if (min2 == 15) {
            udrawable = this.addMessageLiberapay(udrawable);
        } else if (min2 == 30 || min2 == 39 || min2 == 48) {
            udrawable = this.addMessageDedication(udrawable);
        } else if (this.getSource().containsIgnoreCase("arecibo")) {
            udrawable = this.addMessageArecibo(udrawable);
        }
        imageBuilder.setUDrawable(udrawable);
        ImageData imageData = imageBuilder.writeImageTOBEMOVED(fileFormat, this.seed(), os);
        ((ImageDataAbstract)imageData).setStatus(400);
        return imageData;
    }

    private void append(List<String> result, LineLocation lineLocation) {
        if (lineLocation.getDescription() != null) {
            result.add("[From " + lineLocation.getDescription() + " (line " + (lineLocation.getPosition() + 1) + ") ]");
        }
    }

    @Override
    public final DiagramDescription getDescription() {
        return new DiagramDescription("(Error)");
    }

    private List<String> allButLast(List<String> full) {
        return full.subList(0, full.size() - 1);
    }

    private List<String> onlyLast(List<String> full) {
        return full.subList(full.size() - 1, full.size());
    }

    private TextBlockBackcolored getWelcome() throws IOException {
        return new PSystemWelcome(GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT).getGraphicStrings();
    }

    private TextBlock addWelcome(TextBlockBackcolored result) throws IOException {
        TextBlockBackcolored welcome = this.getWelcome();
        return TextBlockUtils.mergeTB(welcome, result, HorizontalAlignment.LEFT);
    }

    private TextBlock addMessageLiberapay(TextBlock source) throws IOException {
        if (LicenseInfo.retrieveNamedOrDistributorQuickIsValid()) {
            return source;
        }
        TextBlockBackcolored message = this.getMessageLiberapay();
        TextBlock result = TextBlockUtils.mergeTB(message, source, HorizontalAlignment.LEFT);
        result = TextBlockUtils.mergeTB(result, message, HorizontalAlignment.LEFT);
        return result;
    }

    private TextBlock addMessagePatreon(TextBlock source) throws IOException {
        if (LicenseInfo.retrieveNamedOrDistributorQuickIsValid()) {
            return source;
        }
        TextBlockBackcolored message = this.getMessagePatreon();
        TextBlock result = TextBlockUtils.mergeTB(message, source, HorizontalAlignment.LEFT);
        result = TextBlockUtils.mergeTB(result, message, HorizontalAlignment.LEFT);
        return result;
    }

    private TextBlock addMessageDedication(TextBlock source) throws IOException {
        if (LicenseInfo.retrieveNamedOrDistributorQuickIsValid()) {
            return source;
        }
        TextBlockBackcolored message = this.getMessageDedication();
        TextBlock result = TextBlockUtils.mergeTB(message, source, HorizontalAlignment.LEFT);
        return result;
    }

    private TextBlock addMessageAdopt(TextBlock source) throws IOException {
        if (LicenseInfo.retrieveNamedOrDistributorQuickIsValid()) {
            return source;
        }
        TextBlockBackcolored message = this.getMessageAdopt();
        TextBlock result = TextBlockUtils.mergeTB(message, source, HorizontalAlignment.LEFT);
        return result;
    }

    private TextBlock addMessageArecibo(TextBlock source) throws IOException {
        UImage message = new UImage(new PixelImage(PSystemVersion.getArecibo(), AffineTransformType.TYPE_BILINEAR));
        TextBlock result = TextBlockUtils.mergeLR(source, TextBlockUtils.fromUImage(message), VerticalAlignment.TOP);
        return result;
    }

    private TextBlockBackcolored getMessageDedication() {
        TextBlock result;
        FlashCodeUtils utils = FlashCodeFactory.getFlashCodeUtils();
        HColorSimple backColor = (HColorSimple)HColorSet.instance().getColorIfValid("#eae2c9");
        BufferedImage qrcode = this.smaller(utils.exportFlashcode("http://plantuml.com/dedication", Color.BLACK, backColor.getColor999()));
        Display disp = Display.create("<b>Add your own dedication into PlantUML", " ", "For just $5 per month!", "Details on <i>[[http://plantuml.com/dedication]]");
        UFont font = UFont.sansSerif(14);
        FontConfiguration fc = new FontConfiguration(font, HColorUtils.BLACK, HColorUtils.BLACK, false);
        TextBlock text = TextBlockUtils.withMargin(disp.create(fc, HorizontalAlignment.LEFT, new SpriteContainerEmpty()), 10.0, 0.0);
        if (qrcode == null) {
            result = text;
        } else {
            UImage qr = new UImage(new PixelImage(qrcode, AffineTransformType.TYPE_NEAREST_NEIGHBOR)).scale(3.0);
            result = TextBlockUtils.mergeLR(text, TextBlockUtils.fromUImage(qr), VerticalAlignment.CENTER);
        }
        return TextBlockUtils.addBackcolor(result, backColor);
    }

    private TextBlockBackcolored getMessageAdopt() {
        TextBlock text;
        HColorSimple backColor = (HColorSimple)HColorSet.instance().getColorIfValid("#eff4d2");
        Display disp = Display.create("<b>Adopt-a-Word and put your message here!", " ", "Details on <i>[[http://plantuml.com/adopt]]", " ");
        UFont font = UFont.sansSerif(14);
        FontConfiguration fc = new FontConfiguration(font, HColorUtils.BLACK, HColorUtils.BLACK, false);
        TextBlock result = text = TextBlockUtils.withMargin(disp.create(fc, HorizontalAlignment.LEFT, new SpriteContainerEmpty()), 10.0, 0.0);
        return TextBlockUtils.addBackcolor(result, backColor);
    }

    private TextBlockBackcolored getMessagePatreon() {
        final UImage message = new UImage(new PixelImage(PSystemVersion.getTime01(), AffineTransformType.TYPE_BILINEAR));
        Color back = new Color(message.getImage(1.0).getRGB(0, 0));
        final HColorSimple backColor = new HColorSimple(back, false);
        FlashCodeUtils utils = FlashCodeFactory.getFlashCodeUtils();
        final BufferedImage qrcode = this.smaller(utils.exportFlashcode("http://plantuml.com/patreon", Color.BLACK, Color.WHITE));
        int scale = 2;
        final double imWidth = message.getWidth() + (qrcode == null ? 0 : qrcode.getWidth() * 2 + 20);
        final double imHeight = qrcode == null ? (double)message.getHeight() : (double)Math.max(message.getHeight(), qrcode.getHeight() * 2 + 10);
        return new TextBlockBackcolored(){

            @Override
            public void drawU(UGraphic ug) {
                if (qrcode == null) {
                    ug.apply(new UTranslate(1.0, 1.0)).draw(message);
                } else {
                    UImage qr = new UImage(new PixelImage(qrcode, AffineTransformType.TYPE_NEAREST_NEIGHBOR)).scale(2.0);
                    ug.apply(new UTranslate(1.0, (imHeight - (double)message.getHeight()) / 2.0)).draw(message);
                    ug.apply(new UTranslate(1 + message.getWidth(), (imHeight - (double)qr.getHeight()) / 2.0)).draw(qr);
                }
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return null;
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(imWidth + 1.0, imHeight + 1.0);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                return MinMax.fromMax(imWidth + 1.0, imHeight + 1.0);
            }

            @Override
            public HColor getBackcolor() {
                return backColor;
            }
        };
    }

    private TextBlockBackcolored getMessageLiberapay() {
        final UImage message = new UImage(new PixelImage(PSystemVersion.getTime15(), AffineTransformType.TYPE_BILINEAR));
        Color back = new Color(message.getImage(1.0).getRGB(0, 0));
        final HColorSimple backColor = new HColorSimple(back, false);
        FlashCodeUtils utils = FlashCodeFactory.getFlashCodeUtils();
        final BufferedImage qrcode = this.smaller(utils.exportFlashcode("http://plantuml.com/lp", Color.BLACK, Color.WHITE));
        int scale = 2;
        final double imWidth = message.getWidth() + (qrcode == null ? 0 : qrcode.getWidth() * 2 + 20);
        final double imHeight = qrcode == null ? (double)message.getHeight() : (double)Math.max(message.getHeight(), qrcode.getHeight() * 2 + 10);
        return new TextBlockBackcolored(){

            @Override
            public void drawU(UGraphic ug) {
                if (qrcode == null) {
                    ug.apply(new UTranslate(1.0, 1.0)).draw(message);
                } else {
                    UImage qr = new UImage(new PixelImage(qrcode, AffineTransformType.TYPE_NEAREST_NEIGHBOR)).scale(2.0);
                    ug.apply(new UTranslate(1.0, (imHeight - (double)message.getHeight()) / 2.0)).draw(message);
                    ug.apply(new UTranslate(1 + message.getWidth(), (imHeight - (double)qr.getHeight()) / 2.0)).draw(qr);
                }
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return null;
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(imWidth + 1.0, imHeight + 1.0);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                return MinMax.fromMax(imWidth + 1.0, imHeight + 1.0);
            }

            @Override
            public HColor getBackcolor() {
                return backColor;
            }
        };
    }

    public int size() {
        return this.trace.size();
    }

    private BufferedImage smaller(BufferedImage im) {
        if (im == null) {
            return null;
        }
        boolean nb = true;
        return im.getSubimage(1, 1, im.getWidth() - 2, im.getHeight() - 2);
    }
}

