/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.graph.ANode;
import znaishaded.net.sourceforge.plantuml.graph.ANodeImpl;
import znaishaded.net.sourceforge.plantuml.graph.Heap;
import znaishaded.net.sourceforge.plantuml.graph.LinkString;

public class Zoda2 {
    private final Map<ANode, Heap> heaps = new LinkedHashMap<ANode, Heap>();

    public ANode getNode(String code) {
        for (ANode n : this.heaps.keySet()) {
            if (!n.getCode().equals(code)) continue;
            return n;
        }
        return null;
    }

    public ANode createAloneNode(String code) {
        if (this.getNode(code) != null) {
            throw new IllegalArgumentException();
        }
        Heap h2 = new Heap();
        ANode n = h2.addNode(code);
        this.heaps.put(n, h2);
        return n;
    }

    public List<? extends ANode> getNodes() {
        return Collections.unmodifiableList(new ArrayList<ANode>(this.heaps.keySet()));
    }

    public Set<Heap> getHeaps() {
        return new HashSet<Heap>(this.heaps.values());
    }

    public void addLink(String link, int diffHeight, Object userData) {
        Heap h2;
        LinkString l;
        try {
            l = new LinkString(link);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return;
        }
        ANode n1 = this.getNode(l.getNode1());
        ANode n2 = this.getNode(l.getNode2());
        Heap h1 = n1 == null ? null : this.heaps.get(n1);
        Heap heap = h2 = n2 == null ? null : this.heaps.get(n2);
        assert (h1 == null || !h1.isEmpty());
        assert (h2 == null || !h2.isEmpty());
        if (h1 == null && h2 == null) {
            Heap h3 = new Heap();
            h3.addLink(link, diffHeight, userData);
            this.recordHeap(h3);
        } else if (h1 == h2) {
            assert (h1 != null && h2 != null);
            h1.addLink(link, diffHeight, userData);
        } else if (h1 == null) {
            h2.addLink(link, diffHeight, userData);
            this.recordHeap(h2);
        } else if (h2 == null) {
            h1.addLink(link, diffHeight, userData);
            this.recordHeap(h1);
        } else {
            assert (h1 != null && h2 != null);
            assert (h1.getNodes().contains(n1));
            h1.importing(n1, n2, h2, diffHeight, userData);
            this.recordHeap(h1);
            assert (this.heapMerged(h1, h2));
        }
    }

    private boolean heapMerged(Heap destination, Heap source) {
        for (ANode n : source.getNodes()) {
            assert (this.heaps.get(n) == destination);
        }
        return true;
    }

    private void recordHeap(Heap h2) {
        for (ANode n : h2.getNodes()) {
            this.heaps.put((ANodeImpl)n, h2);
        }
    }
}

