/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.hector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import znaishaded.net.sourceforge.plantuml.hector.GrowingTree;
import znaishaded.net.sourceforge.plantuml.hector.PinLink;
import znaishaded.net.sourceforge.plantuml.hector.Skeleton;

public class PinLinksContinuousSet {
    private final Collection<PinLink> all = new ArrayList<PinLink>();

    public Skeleton createSkeleton() {
        GrowingTree tree = new GrowingTree();
        ArrayList<PinLink> pendings = new ArrayList<PinLink>(this.all);
        while (pendings.size() > 0) {
            Iterator it = pendings.iterator();
            while (it.hasNext()) {
                PinLink candidat = (PinLink)it.next();
                if (!tree.canBeAdded(candidat)) continue;
                tree.add(candidat);
                it.remove();
            }
        }
        return tree.createSkeleton();
    }

    public void add(PinLink newPinLink) {
        if (this.all.size() == 0) {
            this.all.add(newPinLink);
            return;
        }
        if (this.all.contains(newPinLink)) {
            throw new IllegalArgumentException("already");
        }
        for (PinLink aLink : this.all) {
            if (!newPinLink.doesTouch(aLink)) continue;
            this.all.add(newPinLink);
            return;
        }
        throw new IllegalArgumentException("not connex");
    }

    public void addAll(PinLinksContinuousSet other) {
        if (!this.doesTouch(other)) {
            throw new IllegalArgumentException();
        }
        this.all.addAll(other.all);
    }

    public boolean doesTouch(PinLink other) {
        for (PinLink aLink : this.all) {
            if (!other.doesTouch(aLink)) continue;
            return true;
        }
        return false;
    }

    public boolean doesTouch(PinLinksContinuousSet otherSet) {
        for (PinLink otherLink : otherSet.all) {
            if (!this.doesTouch(otherLink)) continue;
            return true;
        }
        return false;
    }
}

