/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.hector;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import znaishaded.net.sourceforge.plantuml.hector.Pin;
import znaishaded.net.sourceforge.plantuml.hector.PinLink;

public class Skeleton {
    private final List<Pin> pins;
    private final List<PinLink> pinLinks;
    private final SortedSet<Integer> rows = new TreeSet<Integer>();

    public Skeleton(List<Pin> pins, List<PinLink> pinLinks) {
        this.pins = pins;
        this.pinLinks = pinLinks;
        int uid = 0;
        for (Pin pin : pins) {
            pin.setUid(uid++);
            this.rows.add(pin.getRow());
        }
    }

    public SortedSet<Integer> getRows() {
        return this.rows;
    }

    public List<Pin> getPins() {
        return this.pins;
    }

    public Collection<Pin> getPinsOfRow(int row) {
        LinkedHashSet<Pin> result = new LinkedHashSet<Pin>();
        for (Pin pin : this.pins) {
            if (pin.getRow() != row) continue;
            result.add(pin);
        }
        return result;
    }

    public List<PinLink> getPinLinks() {
        return this.pinLinks;
    }
}

