/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.hector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import znaishaded.net.sourceforge.plantuml.hector.Pin;
import znaishaded.net.sourceforge.plantuml.hector.PinLink;
import znaishaded.net.sourceforge.plantuml.hector.Skeleton;
import znaishaded.net.sourceforge.plantuml.hector.SkeletonMutation;

public class SkeletonConfiguration {
    private final int[] position;
    private final Skeleton skeleton;

    public static SkeletonConfiguration getDefault(Skeleton skeleton) {
        SortedSet<Integer> rows = skeleton.getRows();
        HashMap<Integer, Integer> free = new HashMap<Integer, Integer>();
        for (Integer i : rows) {
            free.put(i, 0);
        }
        List<Pin> pins = skeleton.getPins();
        int[] position = new int[pins.size()];
        for (Pin pin : pins) {
            int f;
            position[pin.getUid()] = f = ((Integer)free.get(pin.getRow())).intValue();
            free.put(pin.getRow(), f + 1);
        }
        return new SkeletonConfiguration(skeleton, position);
    }

    public int hashCode() {
        int result = 0;
        for (int v : this.position) {
            result = result * 37 + v;
        }
        return result;
    }

    public boolean equals(Object other) {
        SkeletonConfiguration this2 = (SkeletonConfiguration)other;
        if (this.skeleton != this2.skeleton) {
            throw new IllegalArgumentException();
        }
        if (this.position.length != this2.position.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.position.length; ++i) {
            if (this.position[i] == this2.position[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int minRow = this.skeleton.getRows().first();
        int maxRow = this.skeleton.getRows().last();
        int minCol = Integer.MAX_VALUE;
        int maxCol = Integer.MIN_VALUE;
        for (int c : this.position) {
            if (c > maxCol) {
                maxCol = c;
            }
            if (c >= minCol) continue;
            minCol = c;
        }
        StringBuilder result = new StringBuilder();
        for (int r = minRow; r <= maxRow; ++r) {
            this.appendRow(result, r, minCol, maxCol);
            if (r >= maxRow) continue;
            result.append(" ");
        }
        return result.toString();
    }

    private void appendRow(StringBuilder result, int row, int minCol, int maxCol) {
        result.append("(");
        boolean first = true;
        for (int c = minCol; c <= maxCol; ++c) {
            Pin pin;
            if (!first) {
                result.append("-");
            }
            if ((pin = this.getPin(row, c)) == null) {
                result.append(".");
            } else {
                result.append(pin.getUid());
            }
            first = false;
        }
        result.append(")");
    }

    private Pin getPin(int row, int col) {
        for (Pin p : this.skeleton.getPinsOfRow(row)) {
            if (this.getCol(p) != col) continue;
            return p;
        }
        return null;
    }

    public int getCol(Pin pin) {
        return this.position[pin.getUid()];
    }

    private SkeletonConfiguration(Skeleton skeleton, int[] position) {
        this.position = position;
        this.skeleton = skeleton;
    }

    private Collection<SkeletonMutation> getMutationForRow(int row) {
        Collection<Pin> pins = this.skeleton.getPinsOfRow(row);
        HashSet<Integer> usedCols = new HashSet<Integer>();
        for (Pin pin : pins) {
            usedCols.add(this.getCol(pin));
        }
        ArrayList<SkeletonMutation> result = new ArrayList<SkeletonMutation>();
        for (Pin pin1 : pins) {
            int c = this.getCol(pin1);
            if (!usedCols.contains(c + 1)) {
                result.add(new Move(pin1, 1));
            }
            if (!usedCols.contains(c - 1)) {
                result.add(new Move(pin1, -1));
            }
            for (Pin pin2 : pins) {
                if (pin1 == pin2 || this.getCol(pin1) > this.getCol(pin2)) continue;
                if (this.getCol(pin1) == this.getCol(pin2)) {
                    throw new IllegalStateException();
                }
                result.add(new Switch(pin1, pin2));
            }
        }
        return result;
    }

    public Set<SkeletonConfiguration> getSomeMuteds() {
        HashSet<SkeletonConfiguration> result = new HashSet<SkeletonConfiguration>();
        for (Integer row : this.skeleton.getRows()) {
            for (SkeletonMutation mutation : this.getMutationForRow(row)) {
                result.add(mutation.mutate());
            }
        }
        return result;
    }

    public List<PinLink> getPinLinks() {
        return this.skeleton.getPinLinks();
    }

    public double getLength(PinLink link) {
        double x1 = this.getCol(link.getPin1());
        double y1 = link.getPin1().getRow();
        double x2 = this.getCol(link.getPin2());
        double y2 = link.getPin2().getRow();
        double dx = x2 - x1;
        double dy = y2 - y1;
        return Math.sqrt(dx * dx + dy * dy);
    }

    class Move
    implements SkeletonMutation {
        private final SkeletonConfiguration newConfiguration;

        public Move(Pin pin, int deltaX) {
            int[] copy = new int[SkeletonConfiguration.this.position.length];
            for (int i = 0; i < SkeletonConfiguration.this.position.length; ++i) {
                copy[i] = i == pin.getUid() ? SkeletonConfiguration.this.position[i] + deltaX : SkeletonConfiguration.this.position[i];
            }
            this.newConfiguration = new SkeletonConfiguration(SkeletonConfiguration.this.skeleton, copy);
        }

        @Override
        public SkeletonConfiguration mutate() {
            return this.newConfiguration;
        }
    }

    class Switch
    implements SkeletonMutation {
        private final SkeletonConfiguration newConfiguration;

        public Switch(Pin pin1, Pin pin2) {
            if (pin1 == pin2) {
                throw new IllegalArgumentException();
            }
            int[] copy = new int[SkeletonConfiguration.this.position.length];
            for (int i = 0; i < SkeletonConfiguration.this.position.length; ++i) {
                copy[i] = i == pin1.getUid() ? SkeletonConfiguration.this.position[pin2.getUid()] : (i == pin2.getUid() ? SkeletonConfiguration.this.position[pin1.getUid()] : SkeletonConfiguration.this.position[i]);
            }
            this.newConfiguration = new SkeletonConfiguration(SkeletonConfiguration.this.skeleton, copy);
        }

        @Override
        public SkeletonConfiguration mutate() {
            return this.newConfiguration;
        }
    }
}

