/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.project.Load;
import znaishaded.net.sourceforge.plantuml.project.LoadPlanable;
import znaishaded.net.sourceforge.plantuml.project.Value;
import znaishaded.net.sourceforge.plantuml.project.core.TaskAttribute;
import znaishaded.net.sourceforge.plantuml.project.time.Wink;

public class Solver {
    private final Map<TaskAttribute, Value> values = new LinkedHashMap<TaskAttribute, Value>();
    private final LoadPlanable loadPlanable;

    public Solver(LoadPlanable loadPlanable) {
        this.loadPlanable = loadPlanable;
    }

    public void setData(TaskAttribute attribute, Value value) {
        Wink previousInstant;
        Value previous = this.values.remove((Object)attribute);
        if (previous != null && attribute == TaskAttribute.START && (previousInstant = (Wink)previous).compareTo((Wink)value) > 0) {
            value = previous;
        }
        this.values.put(attribute, value);
        if (this.values.size() > 2) {
            this.removeFirstElement();
        }
        assert (this.values.size() <= 2);
    }

    private void removeFirstElement() {
        Iterator<Map.Entry<TaskAttribute, Value>> it = this.values.entrySet().iterator();
        it.next();
        it.remove();
    }

    public Value getData(TaskAttribute attribute) {
        Value result = this.values.get((Object)attribute);
        if (result == null) {
            if (attribute == TaskAttribute.END) {
                return this.computeEnd();
            }
            if (attribute == TaskAttribute.START) {
                return this.computeStart();
            }
            return Load.inWinks(1);
        }
        return result;
    }

    private Wink computeEnd() {
        Wink current = (Wink)this.values.get((Object)TaskAttribute.START);
        int fullLoad = ((Load)this.values.get((Object)TaskAttribute.LOAD)).getFullLoad();
        while (fullLoad > 0) {
            fullLoad -= this.loadPlanable.getLoadAt(current);
            current = current.increment();
        }
        return current.decrement();
    }

    private Wink computeStart() {
        Wink current = (Wink)this.values.get((Object)TaskAttribute.END);
        for (int fullLoad = ((Load)this.values.get((Object)TaskAttribute.LOAD)).getFullLoad(); fullLoad > 0; fullLoad -= this.loadPlanable.getLoadAt(current)) {
            if ((current = current.decrement()).getWink() > 0) continue;
            return current;
        }
        return current.increment();
    }
}

