/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import java.util.HashSet;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.salt.Cell;
import znaishaded.net.sourceforge.plantuml.salt.element.Segment;
import znaishaded.net.sourceforge.plantuml.salt.element.TableStrategy;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class Grid {
    private final double[] rowsStart;
    private final double[] colsStart;
    private final TableStrategy strategy;
    private final TextBlock title;
    private final Set<Segment> horizontals = new HashSet<Segment>();
    private final Set<Segment> verticals = new HashSet<Segment>();

    public Grid(double[] rowsStart, double[] colsStart, TableStrategy strategy, TextBlock title) {
        this.title = title;
        this.rowsStart = rowsStart;
        this.colsStart = colsStart;
        this.strategy = strategy;
        if (strategy == TableStrategy.DRAW_OUTSIDE || strategy == TableStrategy.DRAW_OUTSIDE_WITH_TITLE || strategy == TableStrategy.DRAW_ALL) {
            this.addOutside();
        }
    }

    private void addOutside() {
        int nbRow = this.rowsStart.length;
        int nbCol = this.colsStart.length;
        for (int c = 0; c < nbCol - 1; ++c) {
            this.horizontals.add(new Segment(0, c));
            this.horizontals.add(new Segment(nbRow - 1, c));
        }
        for (int r = 0; r < nbRow - 1; ++r) {
            this.verticals.add(new Segment(r, 0));
            this.verticals.add(new Segment(r, nbCol - 1));
        }
    }

    public void drawU(UGraphic ug, double x, double y) {
        int col1;
        int row1;
        for (Segment seg : this.horizontals) {
            row1 = seg.getRow();
            col1 = seg.getCol();
            double width = this.colsStart[col1 + 1] - this.colsStart[col1];
            ug.apply(new UTranslate(x + this.colsStart[col1], y + this.rowsStart[row1])).draw(ULine.hline(width));
        }
        for (Segment seg : this.verticals) {
            row1 = seg.getRow();
            col1 = seg.getCol();
            double height = this.rowsStart[row1 + 1] - this.rowsStart[row1];
            ug.apply(new UTranslate(x + this.colsStart[col1], y + this.rowsStart[row1])).draw(ULine.vline(height));
        }
        Dimension2D dim = this.title.calculateDimension(ug.getStringBounder());
        if (dim.getWidth() > 0.0 && dim.getHeight() > 0.0) {
            UGraphic ug2 = ug.apply(new UTranslate(x + 6.0, y - dim.getHeight() * 0.0));
            ug2.apply(HColorUtils.WHITE.bg()).apply(HColorUtils.WHITE).draw(new URectangle(dim));
            this.title.drawU(ug2);
        }
    }

    public void addCell(Cell cell) {
        if (this.strategy == TableStrategy.DRAW_NONE || this.strategy == TableStrategy.DRAW_OUTSIDE || this.strategy == TableStrategy.DRAW_OUTSIDE_WITH_TITLE) {
            return;
        }
        if (this.strategy == TableStrategy.DRAW_HORIZONTAL || this.strategy == TableStrategy.DRAW_ALL) {
            for (int c = cell.getMinCol(); c <= cell.getMaxCol(); ++c) {
                this.horizontals.add(new Segment(cell.getMinRow(), c));
                this.horizontals.add(new Segment(cell.getMaxRow() + 1, c));
            }
        }
        if (this.strategy == TableStrategy.DRAW_VERTICAL || this.strategy == TableStrategy.DRAW_ALL) {
            for (int r = cell.getMinRow(); r <= cell.getMaxRow(); ++r) {
                this.verticals.add(new Segment(r, cell.getMinCol()));
                this.verticals.add(new Segment(r, cell.getMaxCol() + 1));
            }
        }
    }
}

