/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.PaddingParam;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.sequencediagram.InGroupable;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Message;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Note;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.ArrowAndNoteBox;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.ArrowAndParticipant;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.ConstraintSet;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.DrawableSet;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.Frontier;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.GraphicalElement;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.InGroupablesStack;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.MessageArrow;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.MessageSelfArrow;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.NoteBox;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.ParticipantBox;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.ParticipantRange;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.Step1Abstract;
import znaishaded.net.sourceforge.plantuml.skin.ArrowBody;
import znaishaded.net.sourceforge.plantuml.skin.ArrowComponent;
import znaishaded.net.sourceforge.plantuml.skin.ArrowConfiguration;
import znaishaded.net.sourceforge.plantuml.skin.ArrowHead;
import znaishaded.net.sourceforge.plantuml.skin.Component;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.style.Style;

class Step1Message
extends Step1Abstract {
    private final MessageArrow messageArrow;

    Step1Message(ParticipantRange range, StringBounder stringBounder, Message message, DrawableSet drawingSet, Frontier freeY) {
        super(range, stringBounder, message, drawingSet, freeY);
        double x1 = this.getParticipantBox1().getCenterX(stringBounder);
        double x2 = this.getParticipantBox2().getCenterX(stringBounder);
        this.setConfig(this.isSelfMessage() ? this.getSelfArrowType(message) : this.getArrowType(message, x1, x2));
        if (this.isSelfMessage()) {
            this.messageArrow = null;
        } else {
            ArrowComponent comp = drawingSet.getSkin().createComponentArrow(message.getUsedStyles(), this.getConfig(), drawingSet.getSkinParam(), message.getLabelNumbered());
            Component compAliveBox = drawingSet.getSkin().createComponent(new Style[]{ComponentType.ALIVE_BOX_OPEN_OPEN.getDefaultStyleDefinition().getMergedStyle(drawingSet.getSkinParam().getCurrentStyleBuilder())}, ComponentType.ALIVE_BOX_OPEN_OPEN, null, drawingSet.getSkinParam(), null);
            this.messageArrow = new MessageArrow(freeY.getFreeY(range), drawingSet.getSkin(), comp, this.getLivingParticipantBox1(), this.getLivingParticipantBox2(), message.getUrl(), compAliveBox);
        }
        List<Note> noteOnMessages = message.getNoteOnMessages();
        for (Note noteOnMessage : noteOnMessages) {
            ISkinParam skinParam = noteOnMessage.getSkinParamBackcolored(drawingSet.getSkinParam());
            this.addNote(drawingSet.getSkin().createComponent(noteOnMessage.getUsedStyles(), noteOnMessage.getNoteStyle().getNoteComponentType(), null, skinParam, noteOnMessage.getStrings()));
        }
    }

    @Override
    Frontier prepareMessage(ConstraintSet constraintSet, InGroupablesStack inGroupablesStack) {
        Arrow graphic = this.createArrow();
        double arrowYStartLevel = graphic.getArrowYStartLevel(this.getStringBounder());
        double arrowYEndLevel = graphic.getArrowYEndLevel(this.getStringBounder());
        double delta1 = 0.0;
        this.getMessage().setPosYstartLevel(arrowYStartLevel + 0.0);
        double length = this.isSelfMessage() ? graphic.getArrowOnlyWidth(this.getStringBounder()) + this.getLivingParticipantBox1().getLiveThicknessAt(this.getStringBounder(), arrowYStartLevel).getSegment().getLength() : graphic.getArrowOnlyWidth(this.getStringBounder()) + this.getLivingParticipantBox(NotePosition.LEFT).getLifeLine().getRightShift(arrowYStartLevel) + this.getLivingParticipantBox(NotePosition.RIGHT).getLifeLine().getLeftShift(arrowYStartLevel);
        this.incFreeY(graphic.getPreferredHeight(this.getStringBounder()));
        double marginActivateAndDeactive = 0.0;
        if (this.getMessage().isActivateAndDeactive()) {
            marginActivateAndDeactive = 30.0;
            this.incFreeY(marginActivateAndDeactive);
        }
        this.getDrawingSet().addEvent(this.getMessage(), graphic);
        if (this.isSelfMessage()) {
            constraintSet.getConstraintAfter(this.getParticipantBox1()).ensureValue(length);
        } else {
            constraintSet.getConstraint(this.getParticipantBox1(), this.getParticipantBox2()).ensureValue(length);
        }
        double posYendLevel = arrowYEndLevel + marginActivateAndDeactive - 0.0;
        this.getMessage().setPosYendLevel(posYendLevel);
        assert (graphic instanceof InGroupable);
        if (graphic instanceof InGroupable) {
            inGroupablesStack.addElement(graphic);
            inGroupablesStack.addElement(this.getLivingParticipantBox1());
            if (!this.isSelfMessage()) {
                inGroupablesStack.addElement(this.getLivingParticipantBox2());
            }
        }
        return this.getFreeY();
    }

    private boolean isSelfMessage() {
        return this.getParticipantBox1().equals(this.getParticipantBox2());
    }

    private ParticipantBox getParticipantBox1() {
        return this.getLivingParticipantBox1().getParticipantBox();
    }

    private ParticipantBox getParticipantBox2() {
        return this.getLivingParticipantBox2().getParticipantBox();
    }

    private LivingParticipantBox getLivingParticipantBox1() {
        return this.getDrawingSet().getLivingParticipantBox(((Message)this.getMessage()).getParticipant1());
    }

    private LivingParticipantBox getLivingParticipantBox2() {
        return this.getDrawingSet().getLivingParticipantBox(((Message)this.getMessage()).getParticipant2());
    }

    private LivingParticipantBox getLivingParticipantBox(NotePosition position) {
        if (this.isSelfMessage()) {
            throw new IllegalStateException();
        }
        return this.messageArrow.getParticipantAt(this.getStringBounder(), position);
    }

    private Arrow createArrow() {
        if (this.getMessage().isCreate()) {
            return this.createArrowCreate();
        }
        if (this.getMessage().getNoteOnMessages().size() > 0 && this.isSelfMessage()) {
            MessageSelfArrow messageSelfArrow = this.createMessageSelfArrow();
            ArrayList<NoteBox> noteBoxes = new ArrayList<NoteBox>();
            for (int i = 0; i < this.getNotes().size(); ++i) {
                Component note = this.getNotes().get(i);
                Note noteOnMessage = this.getMessage().getNoteOnMessages().get(i);
                noteOnMessage.temporaryProtectedUntilTeozIsStandard();
                noteBoxes.add(this.createNoteBox(this.getStringBounder(), messageSelfArrow, note, noteOnMessage));
            }
            return new ArrowAndNoteBox(this.getStringBounder(), messageSelfArrow, noteBoxes);
        }
        if (this.getMessage().getNoteOnMessages().size() > 0) {
            ArrayList<NoteBox> noteBoxes = new ArrayList<NoteBox>();
            for (int i = 0; i < this.getNotes().size(); ++i) {
                Component note = this.getNotes().get(i);
                Note noteOnMessage = this.getMessage().getNoteOnMessages().get(i);
                noteOnMessage.temporaryProtectedUntilTeozIsStandard();
                noteBoxes.add(this.createNoteBox(this.getStringBounder(), this.messageArrow, note, noteOnMessage));
            }
            return new ArrowAndNoteBox(this.getStringBounder(), this.messageArrow, noteBoxes);
        }
        if (this.isSelfMessage()) {
            return this.createMessageSelfArrow();
        }
        return this.messageArrow;
    }

    private MessageSelfArrow createMessageSelfArrow() {
        double posY = this.getFreeY().getFreeY(this.getParticipantRange());
        double deltaY = 0.0;
        double deltaX = 0.0;
        if (this.getMessage().isActivate()) {
            deltaY -= this.getHalfLifeWidth();
            deltaX += 5.0;
        }
        if (this.getMessage().isDeactivate()) {
            deltaY += this.getHalfLifeWidth();
        }
        Style[] styles = this.getMessage().getUsedStyles();
        ArrowComponent comp = this.getDrawingSet().getSkin().createComponentArrow(styles, this.getConfig(), this.getDrawingSet().getSkinParam(), this.getMessage().getLabelNumbered());
        return new MessageSelfArrow(posY, this.getDrawingSet().getSkin(), comp, this.getLivingParticipantBox1(), deltaY, this.getMessage().getUrl(), deltaX);
    }

    private double getHalfLifeWidth() {
        return this.getDrawingSet().getSkin().createComponent(new Style[]{ComponentType.ALIVE_BOX_OPEN_OPEN.getDefaultStyleDefinition().getMergedStyle(this.getDrawingSet().getSkinParam().getCurrentStyleBuilder())}, ComponentType.ALIVE_BOX_OPEN_OPEN, null, this.getDrawingSet().getSkinParam(), Display.create("")).getPreferredWidth(null) / 2.0;
    }

    private Arrow createArrowCreate() {
        if (this.messageArrow == null) {
            throw new IllegalStateException();
        }
        Arrow result = new ArrowAndParticipant(this.getStringBounder(), this.messageArrow, this.getParticipantBox2(), this.getDrawingSet().getSkinParam().getPadding(PaddingParam.PARTICIPANT));
        if (this.getMessage().getNoteOnMessages().size() > 0) {
            ArrayList<NoteBox> noteBoxes = new ArrayList<NoteBox>();
            for (int i = 0; i < this.getNotes().size(); ++i) {
                Component note = this.getNotes().get(i);
                Note noteOnMessage = this.getMessage().getNoteOnMessages().get(i);
                NoteBox noteBox = this.createNoteBox(this.getStringBounder(), result, note, noteOnMessage);
                if (noteOnMessage.getPosition() == NotePosition.RIGHT) {
                    noteBox.pushToRight(this.getParticipantBox2().getPreferredWidth(this.getStringBounder()) / 2.0);
                }
                noteBoxes.add(noteBox);
            }
            result = new ArrowAndNoteBox(this.getStringBounder(), result, noteBoxes);
        }
        this.getLivingParticipantBox2().create(this.getFreeY().getFreeY(this.getParticipantRange()) + ((GraphicalElement)result).getPreferredHeight(this.getStringBounder()) / 2.0);
        return result;
    }

    private ArrowConfiguration getSelfArrowType(Message m3) {
        ArrowConfiguration result = ArrowConfiguration.withDirectionSelf();
        if (m3.getArrowConfiguration().isDotted()) {
            result = result.withBody(ArrowBody.DOTTED);
        }
        if (m3.getArrowConfiguration().isHidden()) {
            result = result.withBody(ArrowBody.HIDDEN);
        }
        if (m3.getArrowConfiguration().isAsync()) {
            result = result.withHead(ArrowHead.ASYNC);
        }
        if (m3.getArrowConfiguration().getDressing2().getHead() == ArrowHead.CROSSX) {
            result = result.withHead2(m3.getArrowConfiguration().getDressing2().getHead());
        }
        result = result.withPart(m3.getArrowConfiguration().getPart());
        result = result.withColor(m3.getArrowConfiguration().getColor());
        result = result.withDecoration1(m3.getArrowConfiguration().getDecoration1());
        result = result.withDecoration2(m3.getArrowConfiguration().getDecoration2());
        return result;
    }

    private ArrowConfiguration getArrowType(Message m3, double x1, double x2) {
        if (x2 > x1) {
            return m3.getArrowConfiguration();
        }
        return m3.getArrowConfiguration().reverse();
    }
}

