/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.LineParam;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Event;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Message;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.EventsHistoryMode;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.TileWithCallbackY;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.TileWithUpdateStairs;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.ArrowComponent;
import znaishaded.net.sourceforge.plantuml.skin.ArrowConfiguration;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.skin.rose.AbstractComponentRoseArrow;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class CommunicationTile
extends AbstractTile
implements TileWithUpdateStairs,
TileWithCallbackY {
    private final LivingSpace livingSpace1;
    private final LivingSpace livingSpace2;
    private final Message message;
    private final Rose skin;
    private final ISkinParam skinParam;
    public static final double LIVE_DELTA_SIZE = 5.0;

    @Override
    public Event getEvent() {
        return this.message;
    }

    public String toString() {
        return super.toString() + " " + this.message;
    }

    public CommunicationTile(LivingSpace livingSpace1, LivingSpace livingSpace2, Message message, Rose skin, ISkinParam skinParam) {
        if (livingSpace1 == livingSpace2) {
            throw new IllegalArgumentException();
        }
        this.livingSpace1 = livingSpace1;
        this.livingSpace2 = livingSpace2;
        this.message = message;
        this.skin = skin;
        this.skinParam = skinParam;
        if (message.isCreate()) {
            livingSpace2.goCreate();
        }
    }

    public boolean isReverse(StringBounder stringBounder) {
        Real point1 = this.livingSpace1.getPosC(stringBounder);
        Real point2 = this.livingSpace2.getPosC(stringBounder);
        return point1.getCurrentValue() > point2.getCurrentValue();
    }

    private boolean isCreate() {
        return this.message.isCreate();
    }

    private double getArrowThickness() {
        UStroke result = this.skinParam.getThickness(LineParam.sequenceArrow, null);
        if (result == null) {
            return 1.0;
        }
        return result.getThickness();
    }

    private ArrowComponent getComponent(StringBounder stringBounder) {
        ArrowConfiguration arrowConfiguration = this.message.getArrowConfiguration();
        if (this.isReverse(stringBounder)) {
            arrowConfiguration = arrowConfiguration.reverse();
        }
        arrowConfiguration = arrowConfiguration.withThickness(this.getArrowThickness());
        ArrowComponent comp = this.skin.createComponentArrow(this.message.getUsedStyles(), arrowConfiguration, this.skinParam, this.message.getLabelNumbered());
        return comp;
    }

    @Override
    public double getYPoint(StringBounder stringBounder) {
        return this.getComponent(stringBounder).getYPoint(stringBounder);
    }

    @Override
    public void updateStairs(StringBounder stringBounder, double y) {
        AbstractComponentRoseArrow comp = (AbstractComponentRoseArrow)this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        double arrowY = comp.getStartPoint(stringBounder, dim).getY();
        this.livingSpace1.addStepForLivebox(this.getEvent(), y + arrowY);
        this.livingSpace2.addStepForLivebox(this.getEvent(), y + arrowY);
    }

    @Override
    public void drawU(UGraphic ug) {
        Area area;
        String anchor1 = this.message.getPart1Anchor();
        String anchor2 = this.message.getPart2Anchor();
        if (anchor1 != null || anchor2 != null) {
            return;
        }
        StringBounder stringBounder = ug.getStringBounder();
        ArrowComponent comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        double x1 = this.getPoint1(stringBounder).getCurrentValue();
        double x2 = this.getPoint2(stringBounder).getCurrentValue();
        if (this.isReverse(stringBounder)) {
            int level1 = this.livingSpace1.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            int level2 = this.livingSpace2.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            if (level1 > 0) {
                x1 -= 5.0;
            }
            area = new Area(x1 - (x2 += 5.0 * (double)level2), dim.getHeight());
            ug = ug.apply(UTranslate.dx(x2));
            if (this.isCreate()) {
                this.livingSpace2.drawHead(ug, (Context2D)((Object)ug), VerticalAlignment.TOP, HorizontalAlignment.RIGHT);
            }
        } else {
            int level1 = this.livingSpace1.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            int level2 = this.livingSpace2.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            if (level2 > 0) {
                level2 -= 2;
            }
            area = new Area((x2 += 5.0 * (double)level2) - (x1 += 5.0 * (double)level1), dim.getHeight());
            ug = ug.apply(UTranslate.dx(x1));
            if (this.isCreate()) {
                this.livingSpace2.drawHead(ug.apply(UTranslate.dx(area.getDimensionToUse().getWidth())), (Context2D)((Object)ug), VerticalAlignment.TOP, HorizontalAlignment.LEFT);
            }
        }
        comp.drawU(ug, area, (Context2D)((Object)ug));
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        ArrowComponent comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        double height = dim.getHeight();
        if (this.isCreate()) {
            height = Math.max(height, this.livingSpace2.getHeadPreferredDimension(stringBounder).getHeight());
        }
        return height;
    }

    @Override
    public void addConstraints(StringBounder stringBounder) {
        ArrowComponent comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        double width = dim.getWidth();
        Real point1 = this.getPoint1(stringBounder);
        Real point2 = this.getPoint2(stringBounder);
        if (this.isReverse(stringBounder)) {
            int level1 = this.livingSpace1.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            int level2 = this.livingSpace2.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            if (level1 > 0) {
                point1 = point1.addFixed(-5.0);
            }
            point2 = point2.addFixed((double)level2 * 5.0);
            point1.ensureBiggerThan(point2.addFixed(width));
        } else {
            int level2 = this.livingSpace2.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            if (level2 > 0) {
                point2 = point2.addFixed(-5.0);
            }
            point2.ensureBiggerThan(point1.addFixed(width));
        }
    }

    private Real getPoint1(StringBounder stringBounder) {
        return this.livingSpace1.getPosC(stringBounder);
    }

    private Real getPoint2(StringBounder stringBounder) {
        if (this.message.isCreate()) {
            if (this.isReverse(stringBounder)) {
                return this.livingSpace2.getPosD(stringBounder);
            }
            return this.livingSpace2.getPosB();
        }
        return this.livingSpace2.getPosC(stringBounder);
    }

    @Override
    public Real getMinX(StringBounder stringBounder) {
        if (this.isReverse(stringBounder)) {
            return this.getPoint2(stringBounder);
        }
        return this.getPoint1(stringBounder);
    }

    @Override
    public Real getMaxX(StringBounder stringBounder) {
        if (this.isReverse(stringBounder)) {
            return this.getPoint1(stringBounder);
        }
        return this.getPoint2(stringBounder);
    }

    @Override
    public void callbackY(double y) {
        if (this.message.isCreate()) {
            this.livingSpace2.goCreate(y);
        }
    }
}

