/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.svek.extremity.Extremity;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

class ExtremityStateLine1
extends Extremity {
    private UPolygon polygon = new UPolygon();
    private final Point2D dest;
    private final double radius = 7.0;
    private final double angle;

    @Override
    public Point2D somePoint() {
        return this.dest;
    }

    public ExtremityStateLine1(double angle, Point2D center) {
        this.angle = this.manageround(angle);
        this.polygon.addPoint(0.0, 0.0);
        this.dest = new Point2D.Double(center.getX(), center.getY());
        int xWing = 9;
        int yAperture = 4;
        this.polygon.addPoint(-9.0, -4.0);
        int xContact = 5;
        this.polygon.addPoint(-5.0, 0.0);
        this.polygon.addPoint(-9.0, 4.0);
        this.polygon.addPoint(0.0, 0.0);
        this.polygon.rotate(this.angle);
        this.polygon = this.polygon.translate(center.getX(), center.getY());
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.apply(ug.getParam().getColor().bg()).apply(new UTranslate(-7.0 * Math.cos(this.angle), -7.0 * Math.sin(this.angle))).draw(this.polygon);
        ug = ug.apply(HColorUtils.WHITE.bg());
        ug.apply(new UStroke(1.5)).apply(new UTranslate(this.dest.getX() - 7.0, this.dest.getY() - 7.0)).draw(new UEllipse(14.0, 14.0));
        ExtremityStateLine1.drawLine(ug, this.getPointOnCircle(this.dest.getX(), this.dest.getY(), 0.7853981633974483), this.getPointOnCircle(this.dest.getX(), this.dest.getY(), 3.9269908169872414));
        ExtremityStateLine1.drawLine(ug, this.getPointOnCircle(this.dest.getX(), this.dest.getY(), -0.7853981633974483), this.getPointOnCircle(this.dest.getX(), this.dest.getY(), 2.356194490192345));
    }

    private Point2D getPointOnCircle(double centerX, double centerY, double angle) {
        double x = centerX + 7.0 * Math.cos(angle);
        double y = centerY + 7.0 * Math.sin(angle);
        return new Point2D.Double(x, y);
    }

    private static void drawLine(UGraphic ug, Point2D p1, Point2D p2) {
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        ug.apply(new UTranslate(p1.getX(), p1.getY())).draw(new ULine(dx, dy));
    }
}

