/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.commonmark.ext.gfm.tables.internal;

import java.util.ArrayList;
import java.util.List;
import znaishaded.org.commonmark.ext.gfm.tables.TableBlock;
import znaishaded.org.commonmark.ext.gfm.tables.TableBody;
import znaishaded.org.commonmark.ext.gfm.tables.TableCell;
import znaishaded.org.commonmark.ext.gfm.tables.TableHead;
import znaishaded.org.commonmark.ext.gfm.tables.TableRow;
import znaishaded.org.commonmark.node.Block;
import znaishaded.org.commonmark.node.Node;
import znaishaded.org.commonmark.parser.InlineParser;
import znaishaded.org.commonmark.parser.block.AbstractBlockParser;
import znaishaded.org.commonmark.parser.block.AbstractBlockParserFactory;
import znaishaded.org.commonmark.parser.block.BlockContinue;
import znaishaded.org.commonmark.parser.block.BlockStart;
import znaishaded.org.commonmark.parser.block.MatchedBlockParser;
import znaishaded.org.commonmark.parser.block.ParserState;

public class TableBlockParser
extends AbstractBlockParser {
    private final TableBlock block = new TableBlock();
    private final List<CharSequence> bodyLines = new ArrayList<CharSequence>();
    private final List<TableCell.Alignment> columns;
    private final List<String> headerCells;
    private boolean nextIsSeparatorLine = true;

    private TableBlockParser(List<TableCell.Alignment> columns, List<String> headerCells) {
        this.columns = columns;
        this.headerCells = headerCells;
    }

    @Override
    public boolean canHaveLazyContinuationLines() {
        return true;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (state.getLine().toString().contains("|")) {
            return BlockContinue.atIndex(state.getIndex());
        }
        return BlockContinue.none();
    }

    @Override
    public void addLine(CharSequence line) {
        if (this.nextIsSeparatorLine) {
            this.nextIsSeparatorLine = false;
        } else {
            this.bodyLines.add(line);
        }
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
        int headerColumns = this.headerCells.size();
        TableHead head = new TableHead();
        this.block.appendChild(head);
        TableRow headerRow = new TableRow();
        head.appendChild(headerRow);
        for (int i = 0; i < headerColumns; ++i) {
            String cell = this.headerCells.get(i);
            TableCell tableCell = this.parseCell(cell, i, inlineParser);
            tableCell.setHeader(true);
            headerRow.appendChild(tableCell);
        }
        Node body = null;
        for (CharSequence rowLine : this.bodyLines) {
            List<String> cells = TableBlockParser.split(rowLine);
            TableRow row = new TableRow();
            for (int i = 0; i < headerColumns; ++i) {
                String cell = i < cells.size() ? cells.get(i) : "";
                TableCell tableCell = this.parseCell(cell, i, inlineParser);
                row.appendChild(tableCell);
            }
            if (body == null) {
                body = new TableBody();
                this.block.appendChild(body);
            }
            body.appendChild(row);
        }
    }

    private TableCell parseCell(String cell, int column, InlineParser inlineParser) {
        TableCell tableCell = new TableCell();
        if (column < this.columns.size()) {
            tableCell.setAlignment(this.columns.get(column));
        }
        inlineParser.parse(cell.trim(), tableCell);
        return tableCell;
    }

    private static List<String> split(CharSequence input) {
        String line = input.toString().trim();
        if (line.startsWith("|")) {
            line = line.substring(1);
        }
        ArrayList<String> cells = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            switch (c) {
                case '\\': {
                    if (i + 1 < line.length() && line.charAt(i + 1) == '|') {
                        sb.append('|');
                        ++i;
                        continue block4;
                    }
                    sb.append('\\');
                    continue block4;
                }
                case '|': {
                    cells.add(sb.toString());
                    sb.setLength(0);
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (sb.length() > 0) {
            cells.add(sb.toString());
        }
        return cells;
    }

    private static List<TableCell.Alignment> parseSeparator(CharSequence s2) {
        ArrayList<TableCell.Alignment> columns = new ArrayList<TableCell.Alignment>();
        int pipes = 0;
        boolean valid = false;
        int i = 0;
        block5: while (i < s2.length()) {
            char c = s2.charAt(i);
            switch (c) {
                case '|': {
                    ++i;
                    if (++pipes > 1) {
                        return null;
                    }
                    valid = true;
                    continue block5;
                }
                case '-': 
                case ':': {
                    if (pipes == 0 && !columns.isEmpty()) {
                        return null;
                    }
                    boolean left = false;
                    boolean right = false;
                    if (c == ':') {
                        left = true;
                        ++i;
                    }
                    boolean haveDash = false;
                    while (i < s2.length() && s2.charAt(i) == '-') {
                        ++i;
                        haveDash = true;
                    }
                    if (!haveDash) {
                        return null;
                    }
                    if (i < s2.length() && s2.charAt(i) == ':') {
                        right = true;
                        ++i;
                    }
                    columns.add(TableBlockParser.getAlignment(left, right));
                    pipes = 0;
                    continue block5;
                }
                case '\t': 
                case ' ': {
                    ++i;
                    continue block5;
                }
            }
            return null;
        }
        if (!valid) {
            return null;
        }
        return columns;
    }

    private static TableCell.Alignment getAlignment(boolean left, boolean right) {
        if (left && right) {
            return TableCell.Alignment.CENTER;
        }
        if (left) {
            return TableCell.Alignment.LEFT;
        }
        if (right) {
            return TableCell.Alignment.RIGHT;
        }
        return null;
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            CharSequence separatorLine;
            List columns;
            CharSequence line = state.getLine();
            CharSequence paragraph = matchedBlockParser.getParagraphContent();
            if (paragraph != null && paragraph.toString().contains("|") && !paragraph.toString().contains("\n") && (columns = TableBlockParser.parseSeparator(separatorLine = line.subSequence(state.getIndex(), line.length()))) != null && !columns.isEmpty()) {
                List headerCells = TableBlockParser.split(paragraph);
                if (columns.size() >= headerCells.size()) {
                    return BlockStart.of(new TableBlockParser(columns, headerCells)).atIndex(state.getIndex()).replaceActiveBlockParser();
                }
            }
            return BlockStart.none();
        }
    }
}

