/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.enterprise.landing;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.enterprise.DocLifecycleListener;
import org.testingisdocumenting.znai.enterprise.EnterpriseComponentsRegistry;
import org.testingisdocumenting.znai.enterprise.landing.LandingDocEntriesProvider;
import org.testingisdocumenting.znai.enterprise.landing.LandingDocEntry;
import org.testingisdocumenting.znai.structure.DocMeta;

public class StorageBasedLandingDocEntriesProvider
implements LandingDocEntriesProvider,
DocLifecycleListener {
    private final Map<String, DocMeta> docMetaByDocId = this.enumerateDocMetas();

    @Override
    public Stream<LandingDocEntry> provide() {
        return this.docMetaByDocId.entrySet().stream().filter(entry -> ((DocMeta)entry.getValue()).isDisplayOnLanding()).map(entry -> new LandingDocEntry((String)entry.getKey(), ((DocMeta)entry.getValue()).getTitle(), "", ((DocMeta)entry.getValue()).getCategory(), ((DocMeta)entry.getValue()).getDescription()));
    }

    private Map<String, DocMeta> enumerateDocMetas() {
        if (EnterpriseComponentsRegistry.documentationStorage() == null) {
            return new HashMap<String, DocMeta>();
        }
        return EnterpriseComponentsRegistry.documentationStorage().list().stream().collect(Collectors.toMap(DocMeta::getId, Function.identity()));
    }

    @Override
    public void onDocUpdate(DocMeta docMeta) {
        this.docMetaByDocId.put(docMeta.getId(), docMeta);
    }

    @Override
    public void onDocRemove(String docId) {
        this.docMetaByDocId.remove(docId);
    }
}

