/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.table;

import java.nio.file.Path;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.extensions.table.TableDocElementFromParams;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public class TableIncludePlugin
implements IncludePlugin {
    private Path fullPath;
    private TableDocElementFromParams docElementFromParams;

    @Override
    public String id() {
        return "table";
    }

    @Override
    public IncludePlugin create() {
        return new TableIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        ResourcesResolver resourcesResolver = componentsRegistry.resourceResolver();
        MarkupParser parser = componentsRegistry.defaultParser();
        String fileName = pluginParams.getFreeParam();
        String textContent = resourcesResolver.textContent(fileName);
        this.fullPath = resourcesResolver.fullPath(fileName);
        this.docElementFromParams = new TableDocElementFromParams(pluginParams, parser, resourcesResolver, this.fullPath, textContent);
        return this.docElementFromParams.create();
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.concat(Stream.of(AuxiliaryFile.builtTime(this.fullPath)), this.docElementFromParams.mappingAuxiliaryFile());
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.STANDARD.text(this.docElementFromParams.getRearrangedTable().allText());
    }
}

