/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.html;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.structure.Page;
import org.testingisdocumenting.znai.structure.TocItem;

public class DocPageReactProps {
    private final Map<String, ?> asMap;
    private final TocItem tocItem;
    private final Page page;

    public DocPageReactProps(TocItem tocItem, Page page) {
        this.tocItem = tocItem;
        this.page = page;
        this.asMap = this.buildMap();
    }

    public TocItem getTocItem() {
        return this.tocItem;
    }

    public Map<String, ?> toMap() {
        return this.asMap;
    }

    private Map<String, ?> buildMap() {
        LinkedHashMap<String, Object> pageProps = new LinkedHashMap<String, Object>();
        pageProps.put("type", "Page");
        pageProps.put("content", DocPageReactProps.exerciseSuppliers(this.page.getDocElement().toMap().get("content")));
        pageProps.put("lastModifiedTime", this.page.getLastModifiedTime().toEpochMilli());
        pageProps.put("tocItem", this.tocItem.toMap());
        return pageProps;
    }

    private static Object exerciseSuppliers(Object content) {
        if (content instanceof Supplier) {
            return ((Supplier)content).get();
        }
        if (content instanceof Map) {
            return DocPageReactProps.exerciseMapSuppliers((Map)content);
        }
        if (content instanceof List) {
            return DocPageReactProps.exerciseListSuppliers((List)content);
        }
        return content;
    }

    private static Map<String, ?> exerciseMapSuppliers(Map<String, ?> content) {
        return content.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, e -> DocPageReactProps.exerciseSuppliers(e.getValue())));
    }

    private static List<?> exerciseListSuppliers(List<?> content) {
        return content.stream().map(DocPageReactProps::exerciseSuppliers).collect(Collectors.toList());
    }
}

