/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.python;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.testingisdocumenting.znai.python.PythonCode;
import org.testingisdocumenting.znai.utils.JsonUtils;
import org.testingisdocumenting.znai.utils.ResourceUtils;

public class PythonBasedPythonParser {
    private static final String PARSE_COMPLETED = "---parse_completed---";
    public static final PythonBasedPythonParser INSTANCE = new PythonBasedPythonParser();
    private final InputStream inputStream;
    private final OutputStream outputStream;

    private PythonBasedPythonParser() {
        Process process = this.createProcess();
        this.inputStream = process.getInputStream();
        this.outputStream = process.getOutputStream();
    }

    public PythonCode parse(Path path) {
        Map<String, ?> parserResponse;
        this.write(path);
        String json = this.read();
        try {
            parserResponse = JsonUtils.deserializeAsMap(json);
        }
        catch (Exception e) {
            throw new RuntimeException("can't parse python parser output: " + json, e);
        }
        boolean success = (Boolean)parserResponse.get("success");
        if (!success) {
            String error = (String)parserResponse.get("error");
            System.out.println(error);
            throw new RuntimeException("Error from python parser: " + error);
        }
        List warnings = (List)parserResponse.get("warnings");
        if (warnings != null && warnings.size() > 0) {
            System.out.println("Warnings from python parsing:");
            warnings.forEach(warning -> System.out.println("\t" + warning));
        }
        return new PythonCode((List)parserResponse.get("result"));
    }

    private void write(Path path) {
        try {
            this.outputStream.write((path.toString() + "\n").getBytes());
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String read() {
        String line;
        StringBuilder result = new StringBuilder();
        Scanner scanner = new Scanner(this.inputStream);
        while (scanner.hasNextLine() && !(line = scanner.nextLine()).equals(PARSE_COMPLETED)) {
            result.append(line);
        }
        return result.toString();
    }

    private Process createProcess() {
        try {
            String pythonPath = this.getPythonPath();
            Path parserPath = ResourceUtils.tempCopyOfResource("python_parser.py").toAbsolutePath();
            return new ProcessBuilder(new String[0]).command(pythonPath, parserPath.toString()).redirectErrorStream(true).start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getPythonPath() {
        String nodeBin = System.getProperty("python.bin");
        return nodeBin != null ? nodeBin : "python3";
    }
}

